<?php

use yii\db\Migration;

/**
 * Class m200625_174956_update_to_1_2
 */
class m200625_174956_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_adyen}}', 'name', $this->string(191)->notNull()->after('status'));
        $this->addColumn('{{%addon_adyen}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_adyen}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_adyen_item}}', 'adyen_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_adyen_item}}', 'adyen_id');

        $this->dropColumn('{{%addon_adyen}}', 'event');
        $this->dropColumn('{{%addon_adyen}}', 'conditions');
        $this->dropColumn('{{%addon_adyen}}', 'name');
    }
}
