<?php

use yii\db\Migration;

class m171026_035525_init_addon_adyen extends Migration
{
    public function up()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_adyen}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(1),

            // Adyen env
            'live' => $this->boolean()->notNull()->defaultValue(0),
            'live_url_prefix' => $this->string(191),

            // Adyen Auth
            'merchant_account' => $this->text()->notNull(),
            'api_key' => $this->text()->notNull(),
            'origin_key' => $this->text()->notNull(),
            'loading_context' => $this->text()->notNull(),

            // Credit Card Field Settings
            'required' => $this->boolean()->notNull()->defaultValue(0),
            'label' => $this->string(191),
            'hide_label' => $this->boolean()->notNull()->defaultValue(0),
            'description' => $this->text(),
            'currency' => $this->string(3)->notNull()->defaultValue('AUD'), // https://docs.adyen.com/development-resources/currency-codes/
            'locale' => $this->string(5)->notNull()->defaultValue('en_US'), // https://docs.adyen.com/checkout/api-integration/localization-components/#change-language
            'dom_element' => $this->text()->defaultValue('card'),
            'store_details' => $this->boolean()->notNull()->defaultValue(0),
            'holder_name' => $this->boolean()->notNull()->defaultValue(0),
            'styles' => $this->text(),
            'placeholders' => $this->text(),

            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->string(191),

            // Additional Settings
            'created_by' => $this->integer(11),
            'updated_by' => $this->integer(11),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_adyen_item}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),

            'description' => $this->string(127), // Item name
            'quantity' => $this->string(191), // Map to Quantity Field
            'price' => $this->string(191), // Map to Price field
        ], $tableOptions);

        $this->createTable('{{%addon_adyen_payment}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'adyen_id' => $this->integer(11),
            'submission_id' => $this->integer(11),

            'transaction' => $this->text(), // Transaction ID: pspReference
            'result_code' => $this->text(), // https://docs.adyen.com/checkout/payment-result-codes/
            'amount' => $this->text(), // Amount
            'currency' => $this->string(3), // 3-letter currency code
            'response' => $this->text(),

            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);
    }

    public function down()
    {
        $this->dropTable('{{%addon_adyen_payment}}');
        $this->dropTable('{{%addon_adyen_item}}');
        $this->dropTable('{{%addon_adyen}}');
    }

}
