<?php

namespace app\modules\addons\modules\active_campaign\services;

use Yii;
use Exception;

class ActiveCampaignService
{

    /** @var \ActiveCampaign ac */
    private $ac;

    /**
     * ActiveCampaignService constructor.
     * @param $apiUrl
     * @param $apiKey
     */
    public function __construct($apiUrl, $apiKey)
    {
        define("ACTIVECAMPAIGN_URL", $apiUrl);
        define("ACTIVECAMPAIGN_API_KEY", $apiKey);

        spl_autoload_register(function(){
            require_once(Yii::getAlias('@addons/active_campaign/activecampaign_api/includes/ActiveCampaign.class.php'));
        });

        $this->ac = new \ActiveCampaign($apiUrl, $apiKey);

    }

    /**
     * Add or Edit Subscriber
     *
     * @param $contact
     * @return array|false
     * @throws Exception
     */
    public function syncContact($contact)
    {
        return $this->ac->api("contact/sync", $contact);
    }

    /**
     * Get Subscriber Lists
     *
     * @return array
     */
    public function getSubscriberLists()
    {
        $params = [
            'ids'  => 'all',
            'full' => '1',
        ];
        $listCollection  =  (array) $this->ac->api("list/list", $params);

        $lists = [];
        if (is_array($listCollection) && !empty($listCollection)) {
            foreach($listCollection as $list) {
                $list = (array) $list;
                if (isset($list['id'], $list['name'])) {
                    $lists[$list['id']] = $list['name'];
                }
            }
        }

        return $lists;
    }

    /**
     * Get Custom Fields
     *
     * @return array
     */
    public function getCustomFields()
    {
        $customFieldCollection  =  (array) $this->ac->api("list/field/view?ids=all");

        $fields = [];
        if (is_array($customFieldCollection) && !empty($customFieldCollection)) {
            foreach($customFieldCollection as $customField) {
                $customField = (array) $customField;
                if (isset($customField['id'], $customField['title'])) {
                    $fields[$customField['id']] = $customField['title'];
                }
            }
        }

        return $fields;
    }

}