<?php

namespace app\modules\addons\modules\active_campaign\models;

use Yii;

/**
 * This is the model class for table "{{%addon_active_campaign_item}}".
 *
 * @property integer $id
 * @property integer $active_campaign_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class ActiveCampaignField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_active_campaign_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'active_campaign_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'active_campaign_id' => Yii::t('app', 'Active Campaign ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getActiveCampaign()
    {
        return $this->hasOne(ActiveCampaign::class,['id'=>'active_campaign_id']);
    }
}
