<?php

namespace app\modules\addons\modules\active_campaign\models;

use app\components\behaviors\DateTrait;
use app\components\behaviors\RelationTrait;
use app\models\Form;
use app\models\User;
use Yii;
use yii\behaviors\BlameableBehavior;
use yii\behaviors\TimestampBehavior;

/**
 * This is the model class for table "{{%addon_active_campaign}}".
 *
 * @property integer $id
 * @property integer $form_id
 * @property integer $status
 * @property string $api_url
 * @property string $api_key
 * @property string $name
 * @property string $conditions
 * @property integer $event
 * @property string $contact_list
 * @property string $subscriber_email
 * @property string $subscriber_first_name
 * @property string $subscriber_last_name
 * @property string $subscriber_phone
 * @property string $subscriber_orgname
 * @property string $subscriber_tags
 * @property string $subscriber_status
 * @property integer $send_last_broadcast
 * @property integer $created_by
 * @property integer $updated_by
 * @property integer $created_at
 * @property integer $updated_at
 *
 * @property Form $form
 * @property ActiveCampaignField[] $items
 * @property User $author
 * @property User $lastEditor
 */
class ActiveCampaign extends \yii\db\ActiveRecord
{
    use RelationTrait, DateTrait;

    const ON = 1;
    const OFF = 0;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_active_campaign}}';
    }

    /**
     * @inheritdoc
     */
    public static function primaryKey()
    {
        return ['id'];
    }

    /**
     * @inheritdoc
     */
    public function behaviors()
    {
        return [
            BlameableBehavior::class,
            TimestampBehavior::class,
        ];
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'api_url', 'api_key', 'name', 'contact_list', 'subscriber_email'], 'required'],
            [['form_id', 'status', 'send_last_broadcast', 'event', 'created_by', 'updated_by', 'created_at', 'updated_at'], 'integer'],
            [['api_url', 'api_key', 'conditions', 'subscriber_status', 'subscriber_email', 'subscriber_first_name', 'subscriber_last_name', 'subscriber_phone', 'subscriber_orgname', 'subscriber_tags'], 'string'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'status' => Yii::t('app', 'Status'),
            'api_url' => Yii::t('app', 'Api URL'),
            'api_key' => Yii::t('app', 'Api Key'),
            'name' => Yii::t('app', 'Name'),
            'conditions' => Yii::t('app', 'Conditions'),
            'event' => Yii::t('app', 'Event'),
            'contact_list' => Yii::t('app', 'Contact List'),
            'subscriber_status' => Yii::t('app', 'Status'),
            'subscriber_email' => Yii::t('app', 'Email'),
            'subscriber_first_name' => Yii::t('app', 'First Name'),
            'subscriber_last_name' => Yii::t('app', 'Last Name'),
            'subscriber_phone' => Yii::t('app', 'Phone'),
            'subscriber_orgname' => Yii::t('app', 'Organization'),
            'subscriber_tags' => Yii::t('app', 'Tags'),
            'send_last_broadcast' => Yii::t('app', 'Send Last Broadcast'),
            'created_by' => Yii::t('app', 'Created By'),
            'updated_by' => Yii::t('app', 'Updated By'),
            'created_at' => Yii::t('app', 'Created At'),
            'updated_at' => Yii::t('app', 'Updated At'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getForm()
    {
        return $this->hasOne(Form::class, ['id' => 'form_id']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAuthor()
    {
        return $this->hasOne(User::class, ['id' => 'created_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getLastEditor()
    {
        return $this->hasOne(User::class, ['id' => 'updated_by']);
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getItems()
    {
        return $this->hasMany(ActiveCampaignField::class, ['active_campaign_id' => 'id']);
    }

    public function setItems($value)
    {
        $this->loadRelated('items', $value);
    }

    /**
     * @inheritdoc
     */
    public function afterFind()
    {
        $this->contact_list = explode(',', $this->contact_list);

        parent::afterFind();
    }

    /**
     * @inheritdoc
     */
    public function beforeValidate()
    {
        if (is_array($this->contact_list)) {
            $this->contact_list = implode(',', $this->contact_list);
        }

        return parent::beforeValidate();
    }

    /**
     * @inheritdoc
     */
    public function beforeDelete()
    {
        if (parent::beforeDelete()) {
            ActiveCampaignField::deleteAll(["active_campaign_id" => $this->id]);
            return true;
        } else {
            return false;
        }
    }
}
