<?php

use yii\db\Migration;

/**
 * Class m200624_134818_update_to_1_2
 */
class m200624_134818_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_active_campaign}}', 'name', $this->string(191)->notNull()->after('status'));
        $this->addColumn('{{%addon_active_campaign}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_active_campaign}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_active_campaign_field}}', 'active_campaign_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_active_campaign_field}}', 'active_campaign_id');

        $this->dropColumn('{{%addon_active_campaign}}', 'event');
        $this->dropColumn('{{%addon_active_campaign}}', 'conditions');
        $this->dropColumn('{{%addon_active_campaign}}', 'name');
    }
}
