<?php

namespace app\modules\addons\modules\acellemail\models;

use Yii;

/**
 * This is the model class for table "{{%addon_acellemail_item}}".
 *
 * @property integer $id
 * @property integer $acellemail_id
 * @property integer $form_id
 * @property string $form_field
 * @property string $list_field
 */
class AcelleMailField extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%addon_acellemail_field}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['form_id', 'acellemail_id'], 'integer'],
            [['form_field', 'list_field'], 'string', 'max' => 255],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'acellemail_id' => Yii::t('app', 'AcelleMail ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'form_field' => Yii::t('app', 'Form Field'),
            'list_field' => Yii::t('app', 'List Field'),
        ];
    }

    /**
     * @return \yii\db\ActiveQuery
     */
    public function getAcelleMail()
    {
        return $this->hasOne(AcelleMail::class,['acellemail_id'=>'id']);
    }
}
