<?php

use yii\db\Migration;

/**
 * Class m200622_040752_update_to_1_2
 */
class m200622_040752_update_to_1_2 extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        // Add Conditional logic fields
        $this->addColumn('{{%addon_acellemail}}', 'name', $this->string(191)->notNull()->after('status'));
        $this->addColumn('{{%addon_acellemail}}', 'event', $this->integer()->notNull()->defaultValue(1)->after('name'));
        $this->addColumn('{{%addon_acellemail}}', 'conditions', $this->text()->after('event'));

        // Add foreign column to fields
        $this->addColumn('{{%addon_acellemail_field}}', 'acellemail_id', $this->integer(11)->notNull()->after('id'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_acellemail_field}}', 'acellemail_id');

        $this->dropColumn('{{%addon_acellemail}}', 'event');
        $this->dropColumn('{{%addon_acellemail}}', 'conditions');
        $this->dropColumn('{{%addon_acellemail}}', 'name');
    }
}
