<?php
/**
 * Copyright (C) Baluart.COM - All Rights Reserved
 *
 * @since 1.0
 * @author Baluart E.I.R.L.
 * @copyright Copyright (c) 2015 - 2023 Baluart E.I.R.L.
 * @license http://codecanyon.net/licenses/faq Envato marketplace licenses
 * @link https://easyforms.dev/ Easy Forms
 */

use yii\db\Migration;

class m170320_123234_init_addon_acellemail extends Migration
{
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_acellemail}}', [
            // Basic Settings
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11)->notNull(),
            'status' => $this->boolean()->notNull()->defaultValue(0),

            // Authorization
            'api_key' => $this->text()->notNull(),
            'api_url' => $this->text()->notNull(),
            // List Information
            'contact_list' => $this->string(191)->notNull(),
            // Subscriber Fields
            'subscriber_email' => $this->string(191)->notNull(),
            'subscriber_status' => $this->string(191)->notNull()->defaultValue('SUBSCRIBED'),
            // Settings
            'opt_in' => $this->boolean()->defaultValue(0),
            'opt_in_field' => $this->string(191),

            'created_by' => $this->integer(11)->notNull(),
            'updated_by' => $this->integer(11)->notNull(),
            'created_at' => $this->integer(),
            'updated_at' => $this->integer(),
        ], $tableOptions);

        $this->createTable('{{%addon_acellemail_field}}', [
            'id' => $this->primaryKey(),
            'form_id' => $this->integer(11),
            'form_field' => $this->string(191),
            'list_field' => $this->string(191),
        ], $tableOptions);
    }

    public function safeDown()
    {
        $this->dropTable('{{%addon_acellemail_field}}');
        $this->dropTable('{{%addon_acellemail}}');
    }
}
