<?php

namespace app\models;

use Yii;
use yii\db\ActiveRecord;

/**
 * This is the model class for table "stripe_webhooks".
 *
 * @property int $id
 * @property string $event_type Type of Stripe event
 * @property string $event_id Stripe event ID
 * @property string $object_id ID of the Stripe object
 * @property string $object_data JSON encoded object data
 * @property int $created_at Timestamp when webhook was received
 */
class StripeWebhook extends ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'stripe_webhooks';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['event_type', 'event_id', 'object_id', 'object_data', 'created_at'], 'required'],
            [['object_data'], 'string'],
            [['created_at'], 'integer'],
            [['event_type', 'event_id', 'object_id'], 'string', 'max' => 255],
            [['event_id'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'event_type' => 'Event Type',
            'event_id' => 'Event ID',
            'object_id' => 'Object ID',
            'object_data' => 'Object Data',
            'created_at' => 'Created At',
        ];
    }
} 