<?php

namespace app\models;

use app\helpers\ArrayHelper;
use Yii;
use yii\helpers\Json;

/**
 * This is the model class for table "{{%addon_stripe_item}}".
 *
 * @property integer $id
 * @property string $instance_id
 * @property string $serializedData
 * @property string $date
 * @property int $form_id
 * @property int $created_at
 */
class FormIncompleteSubmission extends \yii\db\ActiveRecord
{
    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%form_incomplete_submissions}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['instance_id'], 'string', 'max' => 20],
            [['serializedData', 'date'], 'string'],
            [['form_id', 'created_at'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'stripe_id' => Yii::t('app', 'Stripe ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'description' => Yii::t('app', 'Description'),
            'quantity' => Yii::t('app', 'Quantity'),
            'price' => Yii::t('app', 'Price'),
        ];
    }

}
