<?php

namespace app\models;

use app\helpers\ArrayHelper;
use Yii;
use yii\helpers\Json;

/**
 * This is the model class for table "{{%addon_stripe_item}}".
 *
 * @property integer $id
 * @property integer $active
 * @property string $description
 * @property string $currency_code
 */
class Currency extends \yii\db\ActiveRecord
{

    public $description_with_code;

    /**
     * @inheritdoc
     */
    public static function tableName()
    {
        return '{{%currencies}}';
    }

    /**
     * @inheritdoc
     */
    public function rules()
    {
        return [
            [['description'], 'string', 'max' => 127],
            [['currency_code'], 'string', 'max' => 5],
            [['active'], 'integer'],
        ];
    }

    /**
     * @inheritdoc
     */
    public function attributeLabels()
    {
        return [
            'id' => Yii::t('app', 'ID'),
            'stripe_id' => Yii::t('app', 'Stripe ID'),
            'form_id' => Yii::t('app', 'Form ID'),
            'description' => Yii::t('app', 'Description'),
            'quantity' => Yii::t('app', 'Quantity'),
            'price' => Yii::t('app', 'Price'),
        ];
    }

    public function getDescriptionWithCode() {
        return $this->currency_code . ' - ' . $this->description;
    }
}
