<?php

use yii\db\Schema;
use yii\db\Migration;

/**
 * Class m241104_052802_add_abandoned_form_confirmation
 */
class m241104_052802_add_abandoned_form_confirmation extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%abandon_form_confirmation}}', [
            'id' => Schema::TYPE_PK,
            'form_id' => Schema::TYPE_INTEGER . '(11) NOT NULL',
            'type' => Schema::TYPE_INTEGER . '(1) NOT NULL DEFAULT 0',
            'message' => Schema::TYPE_TEXT,
            'url' => Schema::TYPE_TEXT,
            'send_email' => Schema::TYPE_BOOLEAN . ' NOT NULL DEFAULT FALSE',
            'mail_to' => Schema::TYPE_TEXT,
            'mail_from' => Schema::TYPE_TEXT,
            'mail_subject' => Schema::TYPE_TEXT,
            'mail_message' => Schema::TYPE_TEXT,
            'mail_from_name' => Schema::TYPE_TEXT,
            'mail_receipt_copy' => Schema::TYPE_BOOLEAN . ' DEFAULT FALSE',
            'created_at' => Schema::TYPE_INTEGER,
            'updated_at' => Schema::TYPE_INTEGER,
        ], $tableOptions);

        $this->createIndex("{{%abandon_form_confirmation_form_id}}", "{{%abandon_form_confirmation}}", "form_id");


        $this->alterColumn('{{%abandon_form_confirmation}}', 'url', $this->text());
        $this->alterColumn('{{%abandon_form_confirmation}}', 'mail_to', $this->text());
        $this->alterColumn('{{%abandon_form_confirmation}}', 'mail_from', $this->text());
        $this->alterColumn('{{%abandon_form_confirmation}}', 'mail_subject', $this->text());
        $this->alterColumn('{{%abandon_form_confirmation}}', 'mail_from_name', $this->text());

        $this->addColumn('{{%abandon_form_confirmation}}', 'append', $this->integer()->notNull()->defaultValue(0)->after('url'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'alias', $this->integer()->notNull()->defaultValue(0)->after('append'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'seconds', $this->integer()->after('alias'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'mail_cc', $this->text()->after('mail_from'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'mail_bcc', $this->text()->after('mail_cc'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'mail_attach', $this->integer()->notNull()->defaultValue(1)->after('mail_receipt_copy'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'mail_attachments', $this->text()->after('mail_attach'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_in', $this->integer()->after('mail_attachments'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_in_type', $this->integer()->defaultValue(0)->after('opt_in'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_in_message', $this->text()->after('opt_in_type'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_in_url', $this->text()->after('opt_in_message'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_out', $this->integer()->after('opt_in_url'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_out_type', $this->integer()->defaultValue(0)->after('opt_out'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_out_message', $this->text()->after('opt_out_type'));
        $this->addColumn('{{%abandon_form_confirmation}}', 'opt_out_url', $this->text()->after('opt_out_message'));
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%abandon_form_confirmation}}');
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m241104_052802_add_abandoned_form_confirmation cannot be reverted.\n";

        return false;
    }
    */
}
