<?php

use yii\db\Migration;

/**
 * Class m241103_010655_add_columns_stripe_payment
 */
class m241103_010655_add_columns_stripe_payment extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $this->addColumn('{{%addon_stripe_payment}}', 'subtotal', $this->integer(11));
        $this->addColumn('{{%addon_stripe_payment}}', 'fees', $this->integer(11));
        $this->addColumn('{{%addon_stripe_payment}}', 'total', $this->integer(11));
        $this->addColumn('{{%addon_stripe_payment}}', 'customer_name', $this->string(100));
        $this->addColumn('{{%addon_stripe_payment}}', 'customer_email', $this->string(100));
        $this->addColumn('{{%form_submission}}', 'line_items', $this->text());
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropColumn('{{%addon_stripe_payment}}', 'subtotal');
        $this->dropColumn('{{%addon_stripe_payment}}', 'fees');
        $this->dropColumn('{{%addon_stripe_payment}}', 'total');
        $this->dropColumn('{{%addon_stripe_payment}}', 'customer_name');
        $this->dropColumn('{{%addon_stripe_payment}}', 'customer_email');
        $this->dropColumn('{{%form_submission}}', 'line_items');

    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m241103_010655_add_columns_stripe_payment cannot be reverted.\n";

        return false;
    }
    */
}
