<?php

use yii\db\Migration;

/**
 * Class m241028_151504_init_currencies
 */
class m241028_151504_init_currencies extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%currencies}}', [
            'id' => $this->primaryKey(),
            'currency_code' => $this->string(5),
            'description' => $this->string(127),
            'active' => $this->integer()->defaultValue(1),
        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%currencies}}');
    }
}
