<?php

use yii\db\Migration;

/**
 * Class m241027_043753_init_stripe_coupon
 */
class m241027_043753_init_stripe_coupon extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%addon_stripe_coupon}}', [
            'id' => $this->primaryKey(),
            'stripe_id' => $this->integer(11)->notNull(),
            'form_id' => $this->integer(11),
            'description' => $this->string(127), // Item name
            'code' => $this->string(127), // Item code
            'price' => $this->integer(11), // Map to Price field

        ], $tableOptions);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->dropTable('{{%addon_stripe_item}}');
    }
}
