<?php

use yii\db\Migration;

class m240328_000000_create_stripe_webhooks_table extends Migration
{
    public function up()
    {
        $this->createTable('stripe_webhooks', [
            'id' => $this->primaryKey(),
            'event_type' => $this->string()->notNull()->comment('Type of Stripe event'),
            'event_id' => $this->string()->notNull()->comment('Stripe event ID'),
            'object_id' => $this->string()->notNull()->comment('ID of the Stripe object'),
            'object_data' => $this->text()->notNull()->comment('JSON encoded object data'),
            'created_at' => $this->integer()->notNull()->comment('Timestamp when webhook was received'),
        ]);

        // Add indexes
        $this->createIndex('idx-stripe_webhooks-event_type', 'stripe_webhooks', 'event_type');
        $this->createIndex('idx-stripe_webhooks-event_id', 'stripe_webhooks', 'event_id', true);
        $this->createIndex('idx-stripe_webhooks-object_id', 'stripe_webhooks', 'object_id');
    }

    public function down()
    {
        $this->dropTable('stripe_webhooks');
    }
} 