<?php

use yii\db\Schema;
use yii\db\Migration;

class m150420_183547_init_template extends Migration
{

    private $fifteenMinutesAgo;

    public function init()
    {

        $this->fifteenMinutesAgo = strtotime('-15 minutes');

        parent::init();
    }

    public function safeUp()
    {
        $tableOptions = null;
        if ($this->db->driverName === 'mysql') {
            $tableOptions = 'CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci ENGINE=InnoDB';
        }

        $this->createTable('{{%template_category}}', [
            'id' => Schema::TYPE_PK,
            'name' => Schema::TYPE_TEXT . ' NOT NULL',
            'description' => Schema::TYPE_TEXT,
            'created_at' => Schema::TYPE_INTEGER,
            'updated_at' => Schema::TYPE_INTEGER,
        ], $tableOptions);

        // insert category data
        $columns = ['name', 'description', 'created_at', 'updated_at'];
        $this->batchInsert('{{%template_category}}', $columns, [
            ['Online Forms', 'If you need a ready-to-go form for your website, you\'ve come to the right place.', time(), time()],
            ['Surveys', 'Curious what people think? Need to do some polling? Then this online surveys are made for you.', time(), time()],
            ['Lead Generation', 'A lead generation template is a critical piece of the puzzle on any website designed to attract customer inquiries for follow up.', $this->fifteenMinutesAgo, $this->fifteenMinutesAgo],
            ['Invitation', 'Party? Did someone say party? Add a online invitation to your website, or send it out through email, to make collecting responses a snap.', $this->fifteenMinutesAgo, $this->fifteenMinutesAgo],
            ['Online Order', 'Are you looking for a way to take orders online instead of over the phone? Well then, what you need is an online order form template.', $this->fifteenMinutesAgo, $this->fifteenMinutesAgo],
            ['Registrations', 'Are you an event planner, or has someone "volunteered" you to organize that ski lodge reservation for all of your friends? This templates will help you to make organizing events a painless process.', $this->fifteenMinutesAgo, $this->fifteenMinutesAgo],
            ['Tracking', 'Spreadsheets are so yesterday for inventory and tracking purposes. Instead of a spreadsheet, you need a tracking form to keep tabs on inventory, host evaluations, file addresses, or even to record your exercise habits.', $this->fifteenMinutesAgo, $this->fifteenMinutesAgo],
        ]);

        $this->createTable('{{%template}}', [
            'id' => Schema::TYPE_PK,
            'category_id' => Schema::TYPE_INTEGER . '(11)',
            'name' => Schema::TYPE_TEXT . ' NOT NULL',
            'description' => Schema::TYPE_TEXT,
            'builder' => 'mediumtext', // MySql type
            'html' => 'mediumtext', // MySql type
            'promoted' => Schema::TYPE_BOOLEAN . ' DEFAULT FALSE',
            'slug' => Schema::TYPE_TEXT,
            'created_by' => Schema::TYPE_INTEGER . '(11) NOT NULL',
            'updated_by' => Schema::TYPE_INTEGER . '(11) NOT NULL',
            'created_at' => Schema::TYPE_INTEGER,
            'updated_at' => Schema::TYPE_INTEGER,
        ], $tableOptions);

        $this->insert('{{%template}}', [
            'id' => 1,
            'category_id' => 1,
            'name' => 'Basic Contact Form',
            'description' => 'Contact information is important for business owners, professionals, and other organizations. This form allows you to collect name, email addresses and other information so that you can reach personal or business contacts in the future.',
            'builder' => '{"settings":{"name":"Contact Us","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[]},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Contact Us","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":true,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":false,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Let us know your questions, suggestions and concerns by filling out the contact form below.","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Message","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_1","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","selected":true,"label":"Submit"},{"value":"reset","selected":false,"label":"Reset"},{"value":"image","selected":false,"label":"Image"},{"value":"button","selected":false,"label":"Button"}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"styles":[{"name":"global","selector":"#canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form","selector":"#canvas form","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-group","selector":"#canvas form .form-group","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control","selector":"#canvas form .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control-focus","selector":"#canvas form .form-control:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary","selector":"#canvas form .btn.btn-primary","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary-hover","selector":"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default","selector":"#canvas form .btn.btn-default","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default-hover","selector":"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning","selector":"#canvas form .btn.btn-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning-hover","selector":"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger-hover","selector":"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info-hover","selector":"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"control-label","selector":"#canvas form .control-label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"placeholder","selector":"#canvas form ::placeholder","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"heading","selector":"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"paragraph","selector":"#canvas form p","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"help-block","selector":"#canvas form .help-block","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link","selector":"#canvas form a","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link-hover","selector":"#canvas form a:hover","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step","selector":"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-stage","selector":"#canvas form .steps .step .stage","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-connection","selector":"#canvas form .steps .step:after, #canvas form .steps .step:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current","selector":"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success","selector":"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-title","selector":"#canvas form .steps .step .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current-title","selector":"#canvas form .steps .step.current .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success-title","selector":"#canvas form .steps .step.success .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert","selector":".alert","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-success","selector":".alert-success","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-danger","selector":".alert-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-info","selector":".alert-info","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-warning","selector":".alert-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-field","selector":".has-error .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-text","selector":".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-symbol-asterisk","selector":".required .control-label:after, .required-control .control-label:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"recaptcha","selector":"#recaptcha, .g-recaptcha","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-pad","selector":".signature-pad","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-canvas","selector":".signature-pad canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-input","selector":"input[type=checkbox]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-inline","selector":".checkbox-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-input","selector":"input[type=radio]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-inline","selector":".radio-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-before","selector":".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-after","selector":".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-before","selector":".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-after","selector":".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-before","selector":".custom-control .radio label::before, .custom-control .inline-control-radio label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-after","selector":".custom-control .radio label::after, .custom-control .inline-control-radio label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-before","selector":".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-after","selector":".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev","selector":".btn.prev","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev-hover","selector":"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next","selector":".btn.next","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next-hover","selector":"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar-container","selector":".progress","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar","selector":".progress-bar","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"table","selector":".table","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"well","selector":".well","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}}],"height":417}',
            'html' => '&lt;form id=&quot;form-app&quot;&gt;
&lt;fieldset class=&quot;row&quot;&gt;

&lt;!-- Heading --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;h1 &gt;Contact Us&lt;/h1&gt;
&lt;/div&gt;

&lt;!-- Paragraph Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;p&gt;Let us know your questions, suggestions and concerns by filling out the contact form below.&lt;/p&gt;
&lt;/div&gt;

&lt;!-- Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;
        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Email --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;email_1&quot;&gt;Email&lt;/label&gt;
        &lt;input type=&quot;email&quot; id=&quot;email_1&quot; name=&quot;email_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text Area --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;Message&lt;/label&gt;
        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;&lt;/textarea&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Button --&gt;
&lt;div class=&quot;col-12&quot;&gt;
     &lt;div class=&quot;form-action&quot;&gt;
        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;
    &lt;/div&gt;
&lt;/div&gt;
&lt;/fieldset&gt;
&lt;/form&gt;',
            'promoted' => 1,
            'slug' => 'basic-contact-form',
            'created_by' => 1,
            'updated_by' => 1,
            'created_at' => $this->fifteenMinutesAgo,
            'updated_at' => time(),
        ]);

        $this->insert('{{%template}}', [
            'id' => 2,
            'category_id' => 2,
            'name' => 'Customer Satisfaction Survey',
            'description' => 'You don\'t need an expensive marketing research team to gather detailed information about your customers. Instead, use this survey for a quick and easy way to get invaluable feedback from customers on the quality of your product or service.',
            'builder' => '{"settings":{"name":"Customer Satisfaction Survey","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[]},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Customer Satisfaction Survey","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":true,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":false,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Please take a few moments to complete this satisfaction survey.","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Overall, how satisfied were you with the product \/ service?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Very Satisfied","Satisfied","Neutral","Unsatisfied","Very Unsatisfied","N\/A"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Would you recommend our product \/ service to colleagues or contacts within your industry?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Definitely","Probably","Not Sure","Probably Not","Definitely Not"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_3","name":"id"},"label":{"label":"component.label","type":"input","value":"Would you use our product \/ service in the future?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Less than a month","1-6 months","1-3 years","Over 3 Years","Never used"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_4","name":"id"},"label":{"label":"component.label","type":"input","value":"How often do you use product \/ service?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Once a week","2 to 3 times a month","Once a month","Less than once a month"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_5","name":"id"},"label":{"label":"component.label","type":"input","value":"What aspect of the product \/ service were you most satisfied by?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Quality","Price","Purchase Experience","Installation or First Use Experience","Usage Experience","Customer Service","Repeat Purchase Experience"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"What do you like about the product \/ service?","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_2","name":"id"},"label":{"label":"component.label","type":"input","value":"What do you dislike about the product \/ service?","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_6","name":"id"},"label":{"label":"component.label","type":"input","value":"Thinking of similar products \/ services offered by other companies, how would you compare the product \/ service offered by our company?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Much Better","Somewhat Better","About the Same","Somewhat Worse","Much Worse","Don\u0027t Know"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_1","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","selected":true,"label":"Submit"},{"value":"reset","selected":false,"label":"Reset"},{"value":"image","selected":false,"label":"Image"},{"value":"button","selected":false,"label":"Button"}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"styles":[{"name":"global","selector":"#canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form","selector":"#canvas form","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-group","selector":"#canvas form .form-group","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control","selector":"#canvas form .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control-focus","selector":"#canvas form .form-control:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary","selector":"#canvas form .btn.btn-primary","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary-hover","selector":"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default","selector":"#canvas form .btn.btn-default","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default-hover","selector":"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning","selector":"#canvas form .btn.btn-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning-hover","selector":"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger-hover","selector":"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info-hover","selector":"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"control-label","selector":"#canvas form .control-label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"placeholder","selector":"#canvas form ::placeholder","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"heading","selector":"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"paragraph","selector":"#canvas form p","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"help-block","selector":"#canvas form .help-block","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link","selector":"#canvas form a","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link-hover","selector":"#canvas form a:hover","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step","selector":"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-stage","selector":"#canvas form .steps .step .stage","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-connection","selector":"#canvas form .steps .step:after, #canvas form .steps .step:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current","selector":"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success","selector":"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-title","selector":"#canvas form .steps .step .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current-title","selector":"#canvas form .steps .step.current .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success-title","selector":"#canvas form .steps .step.success .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert","selector":".alert","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-success","selector":".alert-success","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-danger","selector":".alert-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-info","selector":".alert-info","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-warning","selector":".alert-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-field","selector":".has-error .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-text","selector":".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-symbol-asterisk","selector":".required .control-label:after, .required-control .control-label:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"recaptcha","selector":"#recaptcha, .g-recaptcha","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-pad","selector":".signature-pad","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-canvas","selector":".signature-pad canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-input","selector":"input[type=checkbox]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-inline","selector":".checkbox-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-input","selector":"input[type=radio]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-inline","selector":".radio-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-before","selector":".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-after","selector":".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-before","selector":".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-after","selector":".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-before","selector":".custom-control .radio label::before, .custom-control .inline-control-radio label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-after","selector":".custom-control .radio label::after, .custom-control .inline-control-radio label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-before","selector":".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-after","selector":".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev","selector":".btn.prev","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev-hover","selector":"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next","selector":".btn.next","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next-hover","selector":"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar-container","selector":".progress","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar","selector":".progress-bar","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"table","selector":".table","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"well","selector":".well","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}}],"height":1532}',
            'html' => '&lt;form id=&quot;form-app&quot;&gt;
&lt;fieldset class=&quot;row&quot;&gt;

&lt;!-- Heading --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;h1 &gt;Customer Satisfaction Survey&lt;/h1&gt;
&lt;/div&gt;

&lt;!-- Paragraph Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;p&gt;Please take a few moments to complete this satisfaction survey.&lt;/p&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_1&quot;&gt;Overall, how satisfied were you with the product / service?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; class=&quot;form-check-input&quot; value=&quot;Very Satisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_0&quot;&gt;
                Very Satisfied &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; class=&quot;form-check-input&quot; value=&quot;Satisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_1&quot;&gt;
                Satisfied &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; class=&quot;form-check-input&quot; value=&quot;Neutral&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_2&quot;&gt;
                Neutral &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; class=&quot;form-check-input&quot; value=&quot;Unsatisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_3&quot;&gt;
                Unsatisfied &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; class=&quot;form-check-input&quot; value=&quot;Very Unsatisfied&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_4&quot;&gt;
                Very Unsatisfied &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_5&quot; class=&quot;form-check-input&quot; value=&quot;N/A&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_5&quot;&gt;
                N/A &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_2&quot;&gt;Would you recommend our product / service to colleagues or contacts within your industry?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_0&quot; class=&quot;form-check-input&quot; value=&quot;Definitely&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_0&quot;&gt;
                Definitely &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_1&quot; class=&quot;form-check-input&quot; value=&quot;Probably&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_1&quot;&gt;
                Probably &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_2&quot; class=&quot;form-check-input&quot; value=&quot;Not Sure&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_2&quot;&gt;
                Not Sure &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_3&quot; class=&quot;form-check-input&quot; value=&quot;Probably Not&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_3&quot;&gt;
                Probably Not &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_2&quot; id=&quot;radio_2_4&quot; class=&quot;form-check-input&quot; value=&quot;Definitely Not&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_2_4&quot;&gt;
                Definitely Not &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_2&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_3&quot;&gt;Would you use our product / service in the future?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_0&quot; class=&quot;form-check-input&quot; value=&quot;Less than a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_0&quot;&gt;
                Less than a month &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_1&quot; class=&quot;form-check-input&quot; value=&quot;1-6 months&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_1&quot;&gt;
                1-6 months &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_2&quot; class=&quot;form-check-input&quot; value=&quot;1-3 years&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_2&quot;&gt;
                1-3 years &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_3&quot; class=&quot;form-check-input&quot; value=&quot;Over 3 Years&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_3&quot;&gt;
                Over 3 Years &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_3&quot; id=&quot;radio_3_4&quot; class=&quot;form-check-input&quot; value=&quot;Never used&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_3_4&quot;&gt;
                Never used &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_3&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_4&quot;&gt;How often do you use product / service?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_0&quot; class=&quot;form-check-input&quot; value=&quot;Once a week&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_0&quot;&gt;
                Once a week &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_1&quot; class=&quot;form-check-input&quot; value=&quot;2 to 3 times a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_1&quot;&gt;
                2 to 3 times a month &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_2&quot; class=&quot;form-check-input&quot; value=&quot;Once a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_2&quot;&gt;
                Once a month &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_4&quot; id=&quot;radio_4_3&quot; class=&quot;form-check-input&quot; value=&quot;Less than once a month&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_4_3&quot;&gt;
                Less than once a month &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_4&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_5&quot;&gt;What aspect of the product / service were you most satisfied by?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_0&quot; class=&quot;form-check-input&quot; value=&quot;Quality&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_0&quot;&gt;
                Quality &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_1&quot; class=&quot;form-check-input&quot; value=&quot;Price&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_1&quot;&gt;
                Price &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_2&quot; class=&quot;form-check-input&quot; value=&quot;Purchase Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_2&quot;&gt;
                Purchase Experience &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_3&quot; class=&quot;form-check-input&quot; value=&quot;Installation or First Use Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_3&quot;&gt;
                Installation or First Use Experience &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_4&quot; class=&quot;form-check-input&quot; value=&quot;Usage Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_4&quot;&gt;
                Usage Experience &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_5&quot; class=&quot;form-check-input&quot; value=&quot;Customer Service&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_5&quot;&gt;
                Customer Service &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_5&quot; id=&quot;radio_5_6&quot; class=&quot;form-check-input&quot; value=&quot;Repeat Purchase Experience&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_5_6&quot;&gt;
                Repeat Purchase Experience &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_5&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text Area --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;What do you like about the product / service?&lt;/label&gt;
        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text Area --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_2&quot;&gt;What do you dislike about the product / service?&lt;/label&gt;
        &lt;textarea id=&quot;textarea_2&quot; name=&quot;textarea_2&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_6&quot;&gt;Thinking of similar products / services offered by other companies, how would you compare the product / service offered by our company?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_0&quot; class=&quot;form-check-input&quot; value=&quot;Much Better&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_0&quot;&gt;
                Much Better &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_1&quot; class=&quot;form-check-input&quot; value=&quot;Somewhat Better&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_1&quot;&gt;
                Somewhat Better &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_2&quot; class=&quot;form-check-input&quot; value=&quot;About the Same&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_2&quot;&gt;
                About the Same &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_3&quot; class=&quot;form-check-input&quot; value=&quot;Somewhat Worse&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_3&quot;&gt;
                Somewhat Worse &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_4&quot; class=&quot;form-check-input&quot; value=&quot;Much Worse&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_4&quot;&gt;
                Much Worse &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_6&quot; id=&quot;radio_6_5&quot; class=&quot;form-check-input&quot; value=&quot;Don&amp;#x27;t Know&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_6_5&quot;&gt;
                Don&#039;t Know &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_6&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Button --&gt;
&lt;div class=&quot;col-12&quot;&gt;
     &lt;div class=&quot;form-action&quot;&gt;
        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;
    &lt;/div&gt;
&lt;/div&gt;
&lt;/fieldset&gt;
&lt;/form&gt;',
            'promoted' => 1,
            'slug' => 'customer-satisfaction-survey',
            'created_by' => 1,
            'updated_by' => 1,
            'created_at' => $this->fifteenMinutesAgo,
            'updated_at' => $this->fifteenMinutesAgo,
        ]);

        $this->insert('{{%template}}', [
            'id' => 3,
            'category_id' => 1,
            'name' => 'Job Application Form',
            'description' => 'Easy way to apply online. Gather information and upload resume using the form.',
            'builder' => '{"settings":{"name":"Product Manager","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[]},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Product Manager","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":true,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":false,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_1","name":"id"},"text":{"label":"component.text","type":"textarea","value":"\u003Cstrong\u003EWill you be our next Product Manager?\u003C\/strong\u003E","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"snippet","title":"snippet.title","fields":{"id":{"label":"component.id","type":"input","value":"snippet_1","name":"id"},"snippet":{"label":"component.htmlCode","type":"textarea","value":"\u003Cdiv style=\u0022border: 1px solid #DDD; padding: 10px; overflow-y: scroll; height: 200px; margin-bottom: 20px;\u0022\u003E\n\u003Cp\u003E\u003Cstrong\u003EAre you...\u003C\/strong\u003E\u003C\/p\u003E\n\u003Cul\u003E\n\u003Cli\u003EFascinated by software products and how they can impact the lives of their users?\u003C\/li\u003E\n\u003Cli\u003ESomeone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?\u003C\/li\u003E\n\u003Cli\u003EA person that enjoys being a vital part of an organization?\u003C\/li\u003E\n\u003Cli\u003EA believer that great software can provide significant savings of time and money?\u003C\/li\u003E\n\u003C\/ul\u003E\n\u003Cp\u003EIf so, you should consider applying to become our next Product Manager.\u003C\/p\u003E\n\u003Cp\u003EWe are looking for a high energy and fun person to add to our team.\u003C\/p\u003E\n\u003Cp\u003EThey will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.\u003C\/p\u003E\n\u003Cp\u003E\u003Cstrong\u003EResponsibilities:\u003C\/strong\u003E\u003C\/p\u003E\n\u003Cul\u003E\n\u003Cli\u003EDefining new improvements for our web application, gathering requirements \u0026amp; documenting designs\u003C\/li\u003E\n\u003Cli\u003ECollect and interpret customer feedback and needs but realize the customer might not always know what they need\u003C\/li\u003E\n\u003Cli\u003EUtilize a healthy amount of intuition but balance that with the appropriate amount of \u0027data\u0027 to back your decisions\u003C\/li\u003E\n\u003Cli\u003EAbility to prioritize\u003C\/li\u003E\n\u003Cli\u003EManage usability testing of new features to understand the \u0022how\u0022 and \u0022why\u0022 for people who use the software\u003C\/li\u003E\n\u003Cli\u003EProject management, seeing all projects from start to finish, new software every week\u003C\/li\u003E\n\u003Cli\u003ECollaborate with Marketing to define the strategies and define use cases\u003C\/li\u003E\n\u003Cli\u003EWork with the Customer Experience Team to analyze customer feedback and feature requests\u003C\/li\u003E\n\u003Cli\u003EInsure the end product is meeting the goals set in the beginning\u003C\/li\u003E\n\u003C\/ul\u003E\n\u003Cp\u003E\u003Cstrong\u003ESkills:\u003C\/strong\u003E\u003C\/p\u003E\n\u003Cul\u003E\n\u003Cli\u003EKnowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development\u003C\/li\u003E\n\u003Cli\u003EA background or passion for user experience and design\u003C\/li\u003E\n\u003Cli\u003ETechnical understanding of the limitations and possibilities within the Web Applications space\u003C\/li\u003E\n\u003Cli\u003EHighly organized with demonstrated effective verbal and written communication skills\u003C\/li\u003E\n\u003Cli\u003EAbility to act as a liaison between departments and maintain lines of communication\u003C\/li\u003E\n\u003Cli\u003EGoal-oriented but able to make changes and pivots when necessary\u003C\/li\u003E\n\u003C\/ul\u003E\n\u003Cp\u003E*we are an Indianapolis-based company but accept applications for remote team members\u003C\/p\u003E\n\u003C\/div\u003E","name":"snippet"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Last Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_3","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Address","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_1","name":"id"},"label":{"label":"component.label","type":"input","value":"How did you find out about this position?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Current Employee","Career Fair","Newspaper Ad","Radio\/TV Ad","Search Engine","Other"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_4","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"If other, please specify","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Upload your resume","name":"label"},"accept":{"label":"component.accept","type":"input","value":".pdf, .docx, .doc","name":"accept"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minFiles":{"label":"component.minFiles","type":"input","value":"","advanced":true,"name":"minFiles"},"maxFiles":{"label":"component.maxFiles","type":"input","value":"","advanced":true,"name":"maxFiles"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Upload a cover letter","name":"label"},"accept":{"label":"component.accept","type":"input","value":".gif, .jpg, .png","name":"accept"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minFiles":{"label":"component.minFiles","type":"input","value":"","advanced":true,"name":"minFiles"},"maxFiles":{"label":"component.maxFiles","type":"input","value":"","advanced":true,"name":"maxFiles"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Additional info","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_1","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","selected":true,"label":"Submit"},{"value":"reset","selected":false,"label":"Reset"},{"value":"image","selected":false,"label":"Image"},{"value":"button","selected":false,"label":"Button"}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"styles":[{"name":"global","selector":"#canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form","selector":"#canvas form","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-group","selector":"#canvas form .form-group","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control","selector":"#canvas form .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control-focus","selector":"#canvas form .form-control:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary","selector":"#canvas form .btn.btn-primary","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary-hover","selector":"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default","selector":"#canvas form .btn.btn-default","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default-hover","selector":"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning","selector":"#canvas form .btn.btn-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning-hover","selector":"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger-hover","selector":"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info-hover","selector":"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"control-label","selector":"#canvas form .control-label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"placeholder","selector":"#canvas form ::placeholder","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"heading","selector":"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"paragraph","selector":"#canvas form p","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"help-block","selector":"#canvas form .help-block","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link","selector":"#canvas form a","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link-hover","selector":"#canvas form a:hover","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step","selector":"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-stage","selector":"#canvas form .steps .step .stage","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-connection","selector":"#canvas form .steps .step:after, #canvas form .steps .step:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current","selector":"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success","selector":"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-title","selector":"#canvas form .steps .step .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current-title","selector":"#canvas form .steps .step.current .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success-title","selector":"#canvas form .steps .step.success .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert","selector":".alert","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-success","selector":".alert-success","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-danger","selector":".alert-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-info","selector":".alert-info","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-warning","selector":".alert-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-field","selector":".has-error .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-text","selector":".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-symbol-asterisk","selector":".required .control-label:after, .required-control .control-label:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"recaptcha","selector":"#recaptcha, .g-recaptcha","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-pad","selector":".signature-pad","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-canvas","selector":".signature-pad canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-input","selector":"input[type=checkbox]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-inline","selector":".checkbox-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-input","selector":"input[type=radio]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-inline","selector":".radio-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-before","selector":".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-after","selector":".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-before","selector":".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-after","selector":".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-before","selector":".custom-control .radio label::before, .custom-control .inline-control-radio label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-after","selector":".custom-control .radio label::after, .custom-control .inline-control-radio label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-before","selector":".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-after","selector":".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev","selector":".btn.prev","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev-hover","selector":"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next","selector":".btn.next","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next-hover","selector":"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar-container","selector":".progress","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar","selector":".progress-bar","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"table","selector":".table","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"well","selector":".well","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}}],"height":1230}',
            'html' => '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;
&lt;fieldset class=&quot;row&quot;&gt;

&lt;!-- Heading --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;h1 &gt;Product Manager&lt;/h1&gt;
&lt;/div&gt;

&lt;!-- Paragraph Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;p&gt;&lt;strong&gt;Will you be our next Product Manager?&lt;/strong&gt;&lt;/p&gt;
&lt;/div&gt;

&lt;!-- Snippet --&gt;
&lt;div class=&quot;snippet col-12&quot;&gt;&lt;div style=&quot;border: 1px solid #DDD; padding: 10px; overflow-y: scroll; height: 200px; margin-bottom: 20px;&quot;&gt;
&lt;p&gt;&lt;strong&gt;Are you...&lt;/strong&gt;&lt;/p&gt;
&lt;ul&gt;
&lt;li&gt;Fascinated by software products and how they can impact the lives of their users?&lt;/li&gt;
&lt;li&gt;Someone who enjoys collaborating with customers, developers and marketers to develop a roadmap for a product?&lt;/li&gt;
&lt;li&gt;A person that enjoys being a vital part of an organization?&lt;/li&gt;
&lt;li&gt;A believer that great software can provide significant savings of time and money?&lt;/li&gt;
&lt;/ul&gt;
&lt;p&gt;If so, you should consider applying to become our next Product Manager.&lt;/p&gt;
&lt;p&gt;We are looking for a high energy and fun person to add to our team.&lt;/p&gt;
&lt;p&gt;They will have the opportunity to significantly direct and impact the development path of our web application and the future of our product.&lt;/p&gt;
&lt;p&gt;&lt;strong&gt;Responsibilities:&lt;/strong&gt;&lt;/p&gt;
&lt;ul&gt;
&lt;li&gt;Defining new improvements for our web application, gathering requirements &amp;amp; documenting designs&lt;/li&gt;
&lt;li&gt;Collect and interpret customer feedback and needs but realize the customer might not always know what they need&lt;/li&gt;
&lt;li&gt;Utilize a healthy amount of intuition but balance that with the appropriate amount of &#039;data&#039; to back your decisions&lt;/li&gt;
&lt;li&gt;Ability to prioritize&lt;/li&gt;
&lt;li&gt;Manage usability testing of new features to understand the &quot;how&quot; and &quot;why&quot; for people who use the software&lt;/li&gt;
&lt;li&gt;Project management, seeing all projects from start to finish, new software every week&lt;/li&gt;
&lt;li&gt;Collaborate with Marketing to define the strategies and define use cases&lt;/li&gt;
&lt;li&gt;Work with the Customer Experience Team to analyze customer feedback and feature requests&lt;/li&gt;
&lt;li&gt;Insure the end product is meeting the goals set in the beginning&lt;/li&gt;
&lt;/ul&gt;
&lt;p&gt;&lt;strong&gt;Skills:&lt;/strong&gt;&lt;/p&gt;
&lt;ul&gt;
&lt;li&gt;Knowledge of Web Applications, SaaS companies and more than 4 years of experience guiding product development&lt;/li&gt;
&lt;li&gt;A background or passion for user experience and design&lt;/li&gt;
&lt;li&gt;Technical understanding of the limitations and possibilities within the Web Applications space&lt;/li&gt;
&lt;li&gt;Highly organized with demonstrated effective verbal and written communication skills&lt;/li&gt;
&lt;li&gt;Ability to act as a liaison between departments and maintain lines of communication&lt;/li&gt;
&lt;li&gt;Goal-oriented but able to make changes and pivots when necessary&lt;/li&gt;
&lt;/ul&gt;
&lt;p&gt;*we are an Indianapolis-based company but accept applications for remote team members&lt;/p&gt;
&lt;/div&gt;&lt;/div&gt;

&lt;!-- Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;text_1&quot;&gt;Name&lt;/label&gt;
        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;text_2&quot;&gt;Last Name&lt;/label&gt;
        &lt;input type=&quot;text&quot; id=&quot;text_2&quot; name=&quot;text_2&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Email --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;email_1&quot;&gt;Email&lt;/label&gt;
        &lt;input type=&quot;email&quot; id=&quot;email_1&quot; name=&quot;email_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;text_3&quot;&gt;Address&lt;/label&gt;
        &lt;input type=&quot;text&quot; id=&quot;text_3&quot; name=&quot;text_3&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Radio --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt; 
        &lt;label  class=&quot;form-label&quot; for=&quot;radio_1&quot;&gt;How did you find out about this position?&lt;/label&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_0&quot; class=&quot;form-check-input&quot; value=&quot;Current Employee&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_0&quot;&gt;
                Current Employee &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_1&quot; class=&quot;form-check-input&quot; value=&quot;Career Fair&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_1&quot;&gt;
                Career Fair &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_2&quot; class=&quot;form-check-input&quot; value=&quot;Newspaper Ad&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_2&quot;&gt;
                Newspaper Ad &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_3&quot; class=&quot;form-check-input&quot; value=&quot;Radio/TV Ad&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_3&quot;&gt;
                Radio/TV Ad &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_4&quot; class=&quot;form-check-input&quot; value=&quot;Search Engine&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_4&quot;&gt;
                Search Engine &lt;/label&gt;
        &lt;/div&gt;
        &lt;div class=&quot;form-check&quot;&gt;
            &lt;input type=&quot;radio&quot; name=&quot;radio_1&quot; id=&quot;radio_1_5&quot; class=&quot;form-check-input&quot; value=&quot;Other&quot; data-alias=&quot;&quot; &gt;&lt;label class=&quot;form-check-label&quot; for=&quot;radio_1_5&quot;&gt;
                Other &lt;/label&gt;
        &lt;/div&gt; 
        &lt;span id=&quot;radio_1&quot;&gt;&lt;/span&gt;
        
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;text_4&quot;&gt;If other, please specify&lt;/label&gt;
        &lt;input type=&quot;text&quot; id=&quot;text_4&quot; name=&quot;text_4&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- File --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;file_1&quot;&gt;Upload your resume&lt;/label&gt;
        &lt;input type=&quot;file&quot; id=&quot;file_1&quot; name=&quot;file_1[]&quot; data-alias=&quot;&quot; accept=&quot;.pdf, .docx, .doc&quot;&gt;
    &lt;/div&gt;
&lt;/div&gt;


&lt;!-- File --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;file_2&quot;&gt;Upload a cover letter&lt;/label&gt;
        &lt;input type=&quot;file&quot; id=&quot;file_2&quot; name=&quot;file_2[]&quot; data-alias=&quot;&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;
    &lt;/div&gt;
&lt;/div&gt;


&lt;!-- Text Area --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;Additional info&lt;/label&gt;
        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot;&gt;&lt;/textarea&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Button --&gt;
&lt;div class=&quot;col-12&quot;&gt;
     &lt;div class=&quot;form-action&quot;&gt;
        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;
    &lt;/div&gt;
&lt;/div&gt;
&lt;/fieldset&gt;
&lt;/form&gt;',
            'promoted' => 1,
            'slug' => 'job-application-form',
            'created_by' => 1,
            'updated_by' => 1,
            'created_at' => $this->fifteenMinutesAgo,
            'updated_at' => $this->fifteenMinutesAgo,
        ]);

        $this->insert('{{%template}}', [
            'id' => 4,
            'category_id' => 7,
            'name' => 'Bug Tracker',
            'description' => 'Do you need to track bugs for an IT department or a group of developers? With this form, you can collect and track the information you need to quickly and effectively intake clients. ',
            'builder' => '{"settings":{"name":"Bug Tracker","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[]},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Bug Tracker","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":true,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":false,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"paragraph","title":"paragraph.title","fields":{"id":{"label":"component.id","type":"input","value":"paragraph_0","name":"id"},"text":{"label":"component.text","type":"textarea","value":"Report all bugs!","name":"text"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Bug Title","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Issue Description","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Operating System","name":"label"},"options":{"label":"component.options","type":"choice","value":["Windows XP","Windows Vista","Mac OS X","Linux","Other"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-6","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Browser","name":"label"},"options":{"label":"component.options","type":"choice","value":["Internet Explorer","Chrome","Firefox","Safari","Opera","Other"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-6","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_3","name":"id"},"label":{"label":"component.label","type":"input","value":"Assign To","name":"label"},"options":{"label":"component.options","type":"choice","value":["Team Member #1","Team Member #2","Team Member #3"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-9","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_4","name":"id"},"label":{"label":"component.label","type":"input","value":"Priority","name":"label"},"options":{"label":"component.options","type":"choice","value":["Low","Medium","High"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-3","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Upload a Screenshot","name":"label"},"accept":{"label":"component.accept","type":"input","value":".gif, .jpg, .png","name":"accept"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minFiles":{"label":"component.minFiles","type":"input","value":"","advanced":true,"name":"minFiles"},"maxFiles":{"label":"component.maxFiles","type":"input","value":"","advanced":true,"name":"maxFiles"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_5","name":"id"},"label":{"label":"component.label","type":"input","value":"Status","name":"label"},"options":{"label":"component.options","type":"choice","value":["New","Acknowledged","Confirmed","Assigned","Resolved","Closed"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":true,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_1","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","selected":true,"label":"Submit"},{"value":"reset","selected":false,"label":"Reset"},{"value":"image","selected":false,"label":"Image"},{"value":"button","selected":false,"label":"Button"}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"styles":[{"name":"global","selector":"#canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form","selector":"#canvas form","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-group","selector":"#canvas form .form-group","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control","selector":"#canvas form .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control-focus","selector":"#canvas form .form-control:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary","selector":"#canvas form .btn.btn-primary","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary-hover","selector":"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default","selector":"#canvas form .btn.btn-default","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default-hover","selector":"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning","selector":"#canvas form .btn.btn-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning-hover","selector":"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger-hover","selector":"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info-hover","selector":"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"control-label","selector":"#canvas form .control-label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"placeholder","selector":"#canvas form ::placeholder","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"heading","selector":"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"paragraph","selector":"#canvas form p","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"help-block","selector":"#canvas form .help-block","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link","selector":"#canvas form a","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link-hover","selector":"#canvas form a:hover","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step","selector":"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-stage","selector":"#canvas form .steps .step .stage","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-connection","selector":"#canvas form .steps .step:after, #canvas form .steps .step:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current","selector":"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success","selector":"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-title","selector":"#canvas form .steps .step .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current-title","selector":"#canvas form .steps .step.current .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success-title","selector":"#canvas form .steps .step.success .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert","selector":".alert","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-success","selector":".alert-success","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-danger","selector":".alert-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-info","selector":".alert-info","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-warning","selector":".alert-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-field","selector":".has-error .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-error-text","selector":".has-error .help-block, .has-error .control-label, .has-error .radio, .has-error .checkbox, .has-error .radio-inline, .has-error .checkbox-inline, .has-error.radio label, .has-error.checkbox label, .has-error.radio-inline label, .has-error.checkbox-inline label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"validation-symbol-asterisk","selector":".required .control-label:after, .required-control .control-label:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"recaptcha","selector":"#recaptcha, .g-recaptcha","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-pad","selector":".signature-pad","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"signature-canvas","selector":".signature-pad canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-input","selector":"input[type=checkbox]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"checkbox-inline","selector":".checkbox-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-input","selector":"input[type=radio]","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"radio-inline","selector":".radio-inline","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-before","selector":".custom-control .checkbox label::before, .custom-control .inline-control-checkbox label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-after","selector":".custom-control .checkbox label::after, .custom-control .inline-control-checkbox label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-before","selector":".custom-control .checkbox input:checked+label::before, .custom-control .inline-control-checkbox input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-checkbox-checked-after","selector":".custom-control .checkbox input:checked+label::after, .custom-control .inline-control-checkbox input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-before","selector":".custom-control .radio label::before, .custom-control .inline-control-radio label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-after","selector":".custom-control .radio label::after, .custom-control .inline-control-radio label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-before","selector":".custom-control .radio input:checked+label::before, .custom-control .inline-control-radio input:checked+label::before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"custom-control-radio-checked-after","selector":".custom-control .radio input:checked+label::after, .custom-control .inline-control-radio input:checked+label::after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev","selector":".btn.prev","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-prev-hover","selector":"#canvas form .btn.prev:hover, #canvas form .btn.prev:active, #canvas form .btn.prev:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next","selector":".btn.next","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-next-hover","selector":"#canvas form .btn.next:hover, #canvas form .btn.next:active, #canvas form .btn.next:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar-container","selector":".progress","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"progress-bar","selector":".progress-bar","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"table","selector":".table","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"well","selector":".well","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}}],"height":624}',
            'html' => '&lt;form id=&quot;form-app&quot; enctype=&quot;multipart/form-data&quot;&gt;
&lt;fieldset class=&quot;row&quot;&gt;

&lt;!-- Heading --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;h1 &gt;Bug Tracker&lt;/h1&gt;
&lt;/div&gt;

&lt;!-- Paragraph Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;p&gt;Report all bugs!&lt;/p&gt;
&lt;/div&gt;

&lt;!-- Text --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;text_1&quot;&gt;Bug Title&lt;/label&gt;
        &lt;input type=&quot;text&quot; id=&quot;text_1&quot; name=&quot;text_1&quot; value=&quot;&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Text Area --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;textarea_1&quot;&gt;Issue Description&lt;/label&gt;
        &lt;textarea id=&quot;textarea_1&quot; name=&quot;textarea_1&quot; rows=&quot;3&quot; data-alias=&quot;&quot; class=&quot;form-control&quot; required&gt;&lt;/textarea&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Select List --&gt;
&lt;div class=&quot;col-6&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;selectlist_1&quot;&gt;Operating System&lt;/label&gt;
        &lt;select id=&quot;selectlist_1&quot; name=&quot;selectlist_1[]&quot; data-alias=&quot;&quot; class=&quot;form-select&quot; required&gt;
            &lt;option value=&quot;&quot; disabled selected&gt;-Select-&lt;/option&gt;
             &lt;option value=&quot;Windows XP&quot; &gt;Windows XP&lt;/option&gt;     
             &lt;option value=&quot;Windows Vista&quot; &gt;Windows Vista&lt;/option&gt;     
             &lt;option value=&quot;Mac OS X&quot; &gt;Mac OS X&lt;/option&gt;     
             &lt;option value=&quot;Linux&quot; &gt;Linux&lt;/option&gt;     
             &lt;option value=&quot;Other&quot; &gt;Other&lt;/option&gt;     
        &lt;/select&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Select List --&gt;
&lt;div class=&quot;col-6&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;selectlist_2&quot;&gt;Browser&lt;/label&gt;
        &lt;select id=&quot;selectlist_2&quot; name=&quot;selectlist_2[]&quot; data-alias=&quot;&quot; class=&quot;form-select&quot; required&gt;
            &lt;option value=&quot;&quot; disabled selected&gt;-Select-&lt;/option&gt;
             &lt;option value=&quot;Internet Explorer&quot; &gt;Internet Explorer&lt;/option&gt;     
             &lt;option value=&quot;Chrome&quot; &gt;Chrome&lt;/option&gt;     
             &lt;option value=&quot;Firefox&quot; &gt;Firefox&lt;/option&gt;     
             &lt;option value=&quot;Safari&quot; &gt;Safari&lt;/option&gt;     
             &lt;option value=&quot;Opera&quot; &gt;Opera&lt;/option&gt;     
             &lt;option value=&quot;Other&quot; &gt;Other&lt;/option&gt;     
        &lt;/select&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Select List --&gt;
&lt;div class=&quot;col-9&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;selectlist_3&quot;&gt;Assign To&lt;/label&gt;
        &lt;select id=&quot;selectlist_3&quot; name=&quot;selectlist_3[]&quot; data-alias=&quot;&quot; class=&quot;form-select&quot; required&gt;
            &lt;option value=&quot;&quot; disabled selected&gt;-Select-&lt;/option&gt;
             &lt;option value=&quot;Team Member #1&quot; &gt;Team Member #1&lt;/option&gt;     
             &lt;option value=&quot;Team Member #2&quot; &gt;Team Member #2&lt;/option&gt;     
             &lt;option value=&quot;Team Member #3&quot; &gt;Team Member #3&lt;/option&gt;     
        &lt;/select&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Select List --&gt;
&lt;div class=&quot;col-3&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;selectlist_4&quot;&gt;Priority&lt;/label&gt;
        &lt;select id=&quot;selectlist_4&quot; name=&quot;selectlist_4[]&quot; data-alias=&quot;&quot; class=&quot;form-select&quot; required&gt;
            &lt;option value=&quot;&quot; disabled selected&gt;-Select-&lt;/option&gt;
             &lt;option value=&quot;Low&quot; &gt;Low&lt;/option&gt;     
             &lt;option value=&quot;Medium&quot; &gt;Medium&lt;/option&gt;     
             &lt;option value=&quot;High&quot; &gt;High&lt;/option&gt;     
        &lt;/select&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- File --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;file_1&quot;&gt;Upload a Screenshot&lt;/label&gt;
        &lt;input type=&quot;file&quot; id=&quot;file_1&quot; name=&quot;file_1[]&quot; data-alias=&quot;&quot; accept=&quot;.gif, .jpg, .png&quot;&gt;
    &lt;/div&gt;
&lt;/div&gt;


&lt;!-- Select List --&gt;
&lt;div class=&quot;col-12&quot;&gt;
    &lt;div class=&quot;form-group required-control&quot;&gt;
        &lt;label  class=&quot;form-label&quot; for=&quot;selectlist_5&quot;&gt;Status&lt;/label&gt;
        &lt;select id=&quot;selectlist_5&quot; name=&quot;selectlist_5[]&quot; data-alias=&quot;&quot; class=&quot;form-select&quot; required&gt;
            &lt;option value=&quot;&quot; disabled selected&gt;-Select-&lt;/option&gt;
             &lt;option value=&quot;New&quot; &gt;New&lt;/option&gt;     
             &lt;option value=&quot;Acknowledged&quot; &gt;Acknowledged&lt;/option&gt;     
             &lt;option value=&quot;Confirmed&quot; &gt;Confirmed&lt;/option&gt;     
             &lt;option value=&quot;Assigned&quot; &gt;Assigned&lt;/option&gt;     
             &lt;option value=&quot;Resolved&quot; &gt;Resolved&lt;/option&gt;     
             &lt;option value=&quot;Closed&quot; &gt;Closed&lt;/option&gt;     
        &lt;/select&gt;
    &lt;/div&gt;
&lt;/div&gt;

&lt;!-- Button --&gt;
&lt;div class=&quot;col-12&quot;&gt;
     &lt;div class=&quot;form-action&quot;&gt;
        &lt;button type=&quot;submit&quot; id=&quot;button_1&quot; name=&quot;button_1&quot; class=&quot;btn btn-primary&quot;&gt;Submit&lt;/button&gt;
    &lt;/div&gt;
&lt;/div&gt;
&lt;/fieldset&gt;
&lt;/form&gt;',
            'promoted' => 0,
            'slug' => 'bug-tracker',
            'created_by' => 1,
            'updated_by' => 1,
            'created_at' => $this->fifteenMinutesAgo,
            'updated_at' => $this->fifteenMinutesAgo,
        ]);

        $this->insert('{{%template}}', [
            'id' => 5,
            'category_id' => 6,
            'name' => 'Event Planner',
            'description' => 'Be it work or play, it is best planned well in advance. Here is an online form to bookmark upcoming events and to verify the checklist of to-do\'s. With this, you can be sure not to have left behind anything that adds to the fun.',
            'builder' => '{"settings":{"name":"Event Planner","canvas":"#canvas","disabledFieldset":false,"layoutSelected":"","layouts":[{"id":"","name":"Vertical"},{"id":"form-horizontal","name":"Horizontal"},{"id":"form-inline","name":"Inline"}],"formSteps":{"title":"formSteps.title","fields":{"id":{"label":"formSteps.id","type":"input","value":"formSteps"},"steps":{"label":"formSteps.steps","type":"textarea-split","value":[]},"progressBar":{"label":"formSteps.progressBar","type":"checkbox","value":false},"noTitles":{"label":"formSteps.noTitles","type":"checkbox","value":false},"noStages":{"label":"formSteps.noStages","type":"checkbox","value":false},"noSteps":{"label":"formSteps.noSteps","type":"checkbox","value":false}}}},"initForm":[{"name":"heading","title":"heading.title","fields":{"id":{"label":"component.id","type":"input","value":"heading_0","name":"id"},"text":{"label":"component.text","type":"input","value":"Event Planner","name":"text"},"type":{"label":"component.type","type":"select","value":[{"value":"h1","selected":true,"label":"H1"},{"value":"h2","selected":false,"label":"H2"},{"value":"h3","selected":false,"label":"H3"},{"value":"h4","selected":false,"label":"H4"},{"value":"h5","selected":false,"label":"H5"},{"value":"h6","selected":false,"label":"H6"}],"name":"type"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"","advanced":true,"name":"containerClass"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event Name","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event Coordinator","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"email","title":"email.title","fields":{"id":{"label":"component.id","type":"input","value":"email_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Email","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"checkdns":{"label":"component.checkDNS","type":"checkbox","value":false,"advanced":true,"name":"checkdns"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Event Type","name":"label"},"options":{"label":"component.options","type":"choice","value":["Banquet","Dinner Party","Wedding"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-6","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Status","name":"label"},"options":{"label":"component.options","type":"choice","value":["Planning","In Progress","Finished"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-6","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Event Description","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"radio","title":"radio.title","fields":{"id":{"label":"component.groupName","type":"input","value":"radio_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Does your program involve any type of outside activity?","name":"label"},"radios":{"label":"component.radios","type":"choice","value":["Yes","No"],"name":"radios"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"number","title":"number.title","fields":{"id":{"label":"component.id","type":"input","value":"number_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"number","selected":true,"label":"Number"},{"value":"range","selected":false,"label":"Range"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Cost Per Person ($)","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"min":{"label":"component.minNumber","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxNumber","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"integerPattern":{"label":"component.integerPattern","type":"input","value":"","advanced":true,"name":"integerPattern"},"numberPattern":{"label":"component.numberPattern","type":"input","value":"","advanced":true,"name":"numberPattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"},"integerOnly":{"label":"component.integerOnly","type":"checkbox","value":false,"advanced":true,"name":"integerOnly"}},"fresh":false},{"name":"checkbox","title":"checkbox.title","fields":{"id":{"label":"component.groupName","type":"input","value":"checkbox_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Requirements","name":"label"},"checkboxes":{"label":"component.checkboxes","type":"choice","value":["Staffing","Catering","Security"],"name":"checkboxes"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-check","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"inline":{"label":"component.inline","type":"checkbox","value":false,"advanced":true,"name":"inline"}},"fresh":false},{"name":"date","title":"date.title","fields":{"id":{"label":"component.id","type":"input","value":"date_1","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"date","selected":true,"label":"Date"},{"value":"datetime-local","selected":false,"label":"DateTime-Local"},{"value":"time","selected":false,"label":"Time"},{"value":"month","selected":false,"label":"Month"},{"value":"week","selected":false,"label":"Week"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event Start Date","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"min":{"label":"component.minDate","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxDate","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-6","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"date","title":"date.title","fields":{"id":{"label":"component.id","type":"input","value":"date_2","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"date","selected":true,"label":"Date"},{"value":"datetime-local","selected":false,"label":"DateTime-Local"},{"value":"time","selected":false,"label":"Time"},{"value":"month","selected":false,"label":"Month"},{"value":"week","selected":false,"label":"Week"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"Event End Date","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"min":{"label":"component.minDate","type":"input","value":"","advanced":true,"name":"min"},"max":{"label":"component.maxDate","type":"input","value":"","advanced":true,"name":"max"},"step":{"label":"component.stepNumber","type":"input","value":"","advanced":true,"name":"step"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-6","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"textarea","title":"textarea.title","fields":{"id":{"label":"component.id","type":"input","value":"textarea_2","name":"id"},"label":{"label":"component.label","type":"input","value":"Location","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"textarea","value":"","name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"fieldSize":{"label":"component.fieldSize","type":"input","value":"3","advanced":true,"name":"fieldSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_3","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"City","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-4","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"text","title":"text.title","fields":{"id":{"label":"component.id","type":"input","value":"text_4","name":"id"},"inputType":{"label":"component.inputType","type":"select","value":[{"value":"text","selected":true,"label":"Text"},{"value":"tel","selected":false,"label":"Tel"},{"value":"url","selected":false,"label":"URL"},{"value":"color","selected":false,"label":"Color"},{"value":"password","selected":false,"label":"Password"}],"name":"inputType"},"label":{"label":"component.label","type":"input","value":"State","name":"label"},"placeholder":{"label":"component.placeholder","type":"input","value":"","name":"placeholder"},"predefinedValue":{"label":"component.predefinedValue","type":"input","value":"","advanced":true,"name":"predefinedValue"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minlength":{"label":"component.minlength","type":"input","value":"","advanced":true,"name":"minlength"},"maxlength":{"label":"component.maxlength","type":"input","value":"","advanced":true,"name":"maxlength"},"pattern":{"label":"component.pattern","type":"input","value":"","advanced":true,"name":"pattern"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-control","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-4","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"unique":{"label":"component.unique","type":"checkbox","value":false,"advanced":true,"name":"unique"}},"fresh":false},{"name":"selectlist","title":"selectlist.title","fields":{"id":{"label":"component.id","type":"input","value":"selectlist_3","name":"id"},"label":{"label":"component.label","type":"input","value":"Country","name":"label"},"options":{"label":"component.options","type":"choice","value":["United States","United Kingdom","Australia","Canada","France","----","Afghanistan","Albania","Algeria","Andorra","Angola","Antigua \u0026 Deps","Argentina","Armenia","Austria","Azerbaijan","Bahamas","Bahrain","Bangladesh","Barbados","Belarus","Belgium","Belize","Benin","Bhutan","Bolivia","Bosnia Herzegovina","Botswana","Brazil","Brunei","Bulgaria","Burkina","Burundi","Cambodia","Cameroon","Cape Verde","Central African Rep","Chad","Chile","China","Colombia","Comoros","Congo","Congo {Democratic Rep}","Costa Rica","Croatia","Cuba","Cyprus","Czech Republic","Denmark","Djibouti","Dominica","Dominican Republic","East Timor","Ecuador","Egypt","El Salvador","Equatorial Guinea","Eritrea","Estonia","Ethiopia","Fiji","Finland","Gabon","Gambia","Georgia","Germany","Ghana","Greece","Grenada","Guatemala","Guinea","Guinea-Bissau","Guyana","Haiti","Honduras","Hungary","Iceland","India","Indonesia","Iran","Iraq","Ireland {Republic}","Israel","Italy","Ivory Coast","Jamaica","Japan","Jordan","Kazakhstan","Kenya","Kiribati","Korea North","Korea South","Kosovo","Kuwait","Kyrgyzstan","Laos","Latvia","Lebanon","Lesotho","Liberia","Libya","Liechtenstein","Lithuania","Luxembourg","Macedonia","Madagascar","Malawi","Malaysia","Maldives","Mali","Malta","Marshall Islands","Mauritania","Mauritius","Mexico","Micronesia","Moldova","Monaco","Mongolia","Montenegro","Morocco","Mozambique","Myanmar, {Burma}","Namibia","Nauru","Nepal","Netherlands","New Zealand","Nicaragua","Niger","Nigeria","Norway","Oman","Pakistan","Palau","Panama","Papua New Guinea","Paraguay","Peru","Philippines","Poland","Portugal","Qatar","Romania","Russian Federation","Rwanda","St Kitts \u0026 Nevis","St Lucia","Saint Vincent \u0026 the Grenadines","Samoa","San Marino","Sao Tome \u0026 Principe","Saudi Arabia","Senegal","Serbia","Seychelles","Sierra Leone","Singapore","Slovakia","Slovenia","Solomon Islands","Somalia","South Africa","South Sudan","Spain","Sri Lanka","Sudan","Suriname","Swaziland","Sweden","Switzerland","Syria","Taiwan","Tajikistan","Tanzania","Thailand","Togo","Tonga","Trinidad \u0026 Tobago","Tunisia","Turkey","Turkmenistan","Tuvalu","Uganda","Ukraine","United Arab Emirates","Uruguay","Uzbekistan","Vanuatu","Vatican City","Venezuela","Vietnam","Yemen","Zambia","Zimbabwe"],"name":"options"},"placeholder":{"label":"component.placeholder","type":"input","value":"-Select-","name":"placeholder"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"cssClass":{"label":"component.cssClass","type":"input","value":"form-select","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-4","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"},"multiple":{"label":"component.multiple","type":"checkbox","value":false,"advanced":true,"name":"multiple"}},"fresh":false},{"name":"file","title":"file.title","fields":{"id":{"label":"component.id","type":"input","value":"file_1","name":"id"},"label":{"label":"component.label","type":"input","value":"Attach Detailed Itinerary","name":"label"},"accept":{"label":"component.accept","type":"input","value":".txt, .pdf, .doc, .docx","name":"accept"},"helpText":{"label":"component.helpText","type":"textarea","value":"","advanced":true,"name":"helpText"},"helpTextPlacement":{"label":"component.helpTextPlacement","type":"select","value":[{"value":"below","selected":true,"label":"Below inputs"},{"value":"above","selected":false,"label":"Above inputs"}],"advanced":true,"name":"helpTextPlacement"},"minFiles":{"label":"component.minFiles","type":"input","value":"","advanced":true,"name":"minFiles"},"maxFiles":{"label":"component.maxFiles","type":"input","value":"","advanced":true,"name":"maxFiles"},"minSize":{"label":"component.minSize","type":"input","value":"","advanced":true,"name":"minSize"},"maxSize":{"label":"component.maxSize","type":"input","value":"","advanced":true,"name":"maxSize"},"cssClass":{"label":"component.cssClass","type":"input","value":"","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"alias":{"label":"component.alias","type":"input","value":"","advanced":true,"name":"alias"},"required":{"label":"component.required","type":"checkbox","value":false,"advanced":true,"name":"required"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false},{"name":"button","title":"button.title","fields":{"id":{"label":"component.id","type":"input","value":"button_1","name":"id"},"inputType":{"label":"component.type","type":"select","value":[{"value":"submit","selected":true,"label":"Submit"},{"value":"reset","selected":false,"label":"Reset"},{"value":"image","selected":false,"label":"Image"},{"value":"button","selected":false,"label":"Button"}],"name":"inputType"},"buttonText":{"label":"component.buttonText","type":"input","value":"Submit","name":"buttonText"},"label":{"label":"component.label","type":"input","value":"","advanced":true,"name":"label"},"src":{"label":"component.src","type":"input","value":"","advanced":true,"name":"src"},"cssClass":{"label":"component.cssClass","type":"input","value":"btn btn-primary","advanced":true,"name":"cssClass"},"labelClass":{"label":"component.labelClass","type":"input","value":"form-label","advanced":true,"name":"labelClass"},"containerClass":{"label":"component.containerClass","type":"input","value":"col-12","advanced":true,"name":"containerClass"},"readOnly":{"label":"component.readOnly","type":"checkbox","value":false,"advanced":true,"name":"readOnly"},"disabled":{"label":"component.disabled","type":"checkbox","value":false,"advanced":true,"name":"disabled"}},"fresh":false}],"styles":[{"name":"global","selector":"#canvas","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form","selector":"#canvas form","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-group","selector":"#canvas form .form-group","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control","selector":"#canvas form .form-control","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"form-control-focus","selector":"#canvas form .form-control:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary","selector":"#canvas form .btn.btn-primary","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-primary-hover","selector":"#canvas form .btn.btn-primary:hover, #canvas form .btn.btn-primary:active, #canvas form .btn.btn-primary:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default","selector":"#canvas form .btn.btn-default","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-default-hover","selector":"#canvas form .btn.btn-default:hover, #canvas form .btn.btn-default:active, #canvas form .btn.btn-default:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning","selector":"#canvas form .btn.btn-warning","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-warning-hover","selector":"#canvas form .btn.btn-warning:hover, #canvas form .btn.btn-warning:active, #canvas form .btn.btn-warning:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-danger-hover","selector":"#canvas form .btn.btn-danger:hover, #canvas form .btn.btn-danger:active, #canvas form .btn.btn-danger:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info","selector":"#canvas form .btn.btn-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"button-info-hover","selector":"#canvas form .btn.btn-info:hover, #canvas form .btn.btn-info:active, #canvas form .btn.btn-info:focus","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"control-label","selector":"#canvas form .control-label","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"placeholder","selector":"#canvas form ::placeholder","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"heading","selector":"#canvas form h1, #canvas form h2, #canvas form h3, #canvas form h4, #canvas form h5, #canvas form h6, #canvas form .legend","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"paragraph","selector":"#canvas form p","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"help-block","selector":"#canvas form .help-block","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link","selector":"#canvas form a","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"link-hover","selector":"#canvas form a:hover","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step","selector":"#canvas form .steps .step .stage, #canvas form .steps .step:before, #canvas form .steps .step:after","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-stage","selector":"#canvas form .steps .step .stage","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-connection","selector":"#canvas form .steps .step:after, #canvas form .steps .step:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current","selector":"#canvas form .steps .step.current .stage, #canvas form .steps .step.current:after, #canvas form .steps .step.current:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success","selector":"#canvas form .steps .step.success .stage, #canvas form .steps .step.success:after, #canvas form .steps .step.success:before","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-title","selector":"#canvas form .steps .step .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-current-title","selector":"#canvas form .steps .step.current .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"step-success-title","selector":"#canvas form .steps .step.success .title","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert","selector":".alert","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-success","selector":".alert-success","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-style-position":"","list-style-type":"","margin":"","margin-bottom":"","margin-left":"","margin-right":"","margin-top":"","marker-offset":"","marks":"","max-height":"","max-width":"","min-height":"","min-width":"","opacity":"","orphans":"","outline":"","outline-color":"","outline-offset":"","outline-style":"","outline-width":"","overflow":"","overflow-x":"","padding":"","padding-bottom":"","padding-left":"","padding-right":"","padding-top":"","page-break-after":"","page-break-before":"","page-break-inside":"","perspective":"","perspective-origin":"","position":"","quotes":"","resize":"","right":"","tab-size":"","table-layout":"","text-align":"","text-align-last":"","text-decoration":"","text-decoration-color":"","text-decoration-line":"","text-decoration-style":"","text-indent":"","text-shadow":"","text-transform":"","top":"","transform":"","transform-origin":"","transform-style":"","transition":"","transition-delay":"","transition-duration":"","transition-property":"","transition-timing-function":"","vertical-align":"","visibility":"","white-space":"","widows":"","width":"","word-spacing":"","word-wrap":"","z-index":""}},{"name":"alert-danger","selector":".alert-danger","properties":{"animation":"","animation-delay":"","animation-direction":"","animation-duration":"","animation-iteration-count":"","animation-name":"","animation-play-state":"","animation-timing-function":"","azimuth":"","backface-visibility":"","background":"","background-attachment":"","background-clip":"","background-color":"","background-image":"","background-origin":"","background-position":"","background-repeat":"","background-size":"","bleed":"","border":"","border-bottom":"","border-bottom-color":"","border-bottom-left-radius":"","border-bottom-right-radius":"","border-bottom-style":"","border-bottom-width":"","border-collapse":"","border-color":"","border-image":"","border-image-outset":"","border-image-repeat":"","border-image-source":"","border-image-width":"","border-left":"","border-left-color":"","border-left-style":"","border-left-width":"","border-radius":"","border-right":"","border-right-color":"","border-right-style":"","border-right-width":"","border-spacing":"","border-style":"","border-top":"","border-top-color":"","border-top-left-radius":"","border-top-right-radius":"","border-top-style":"","border-top-width":"","border-width":"","bottom":"","box-shadow":"","box-sizing":"","caption-side":"","clear":"","clip":"","color":"","column-count":"","column-fill":"","column-gap":"","column-rule":"","column-rule-color":"","column-rule-style":"","column-rule-width":"","column-span":"","column-width":"","columns":"","content":"","counter-increment":"","counter-reset":"","cursor":"","direction":"","display":"","empty-cells":"","float":"","font":"","font-family":"","font-size":"","font-size-adjust":"","font-stretch":"","font-style":"","font-variant":"","font-weight":"","height":"","hyphens":"","image-rendering":"","left":"","letter-spacing":"","line-height":"","list-style":"","list-style-image":"","list-styl