<?php

use app\helpers\SubmissionHelper;
use yii\web\View;

/* @var $this View view component instance */
/* @var $message string Custom Message */
/* @var $fieldValues array Submission data for replacement token */
/* @var $fieldData array Submission data for print details */
/* @var $receipt_copy boolean Includes a Form Submission Copy */
/* @var $formID integer Form ID */
/* @var $submissionID integer Submission ID */
/* @var $submissionModel \app\models\FormSubmission */

$payment_status = $submissionModel->getPaymentStatus();
$package_total = $submissionModel->package_total;
$payments_received = $submissionModel->getPaymentsTotal();
$balance = (empty($package_total) ? 0 : $package_total) - (empty($payments_received) ? 0 : $payments_received);

?>
<div class="content">

<!--    <p><strong>A new form has been submitted</strong></p>-->

    <p>Assalamu Alaikum,</p>

    <p>
        This is to notify you of a new travel form submission processed through our Dar El Salam Travel CRM system.
        The submission below details a recent registration for our upcoming travel experience, requiring your immediate
        review and processing of the traveler's application and associated documentation.
    </p>

    <table style="width: 100%; border-collapse: collapse; margin: 20px 0;">
        <tr>
            <td style="width: 25%; text-align: center;">
                <span style="font-weight:bold;">Payment Status</span><br />
                <span style="<?= $payment_status == 'Paid' ? 'color:green' : ($payment_status == 'Partial' ? 'color:blue;' : 'color:red') ?>" data-key="status"><?= $payment_status ?></span>
            </td>
            <td style="width: 25%; text-align: center;">
                <span style="font-weight:bold;">Package Total</span><br />
                <?= Yii::$app->formatter->asCurrency(empty($package_total) ? 0 : $package_total / 100)  ?>
            </td>
            <td style="width: 25%; text-align: center;">
                <span style="font-weight:bold;">Payments Received</span><br />
                <?= Yii::$app->formatter->asCurrency(empty($payments_received) ? 0 : $payments_received / 100)  ?>
            </td>
            <td style="width: 25%; text-align: center;">
                <span style="font-weight:bold;">Payment Balance</span><br />
                <span style="<?= $balance <= 0 ? 'color:green' : ($balance != $package_total ? 'color:blue;' : 'color:red') ?>" data-key="status"><?= Yii::$app->formatter->asCurrency($balance / 100) ?></span>
            </td>
        </tr>
    </table>

    <?php if ($receipt_copy && count($fieldData) > 0) : ?>

    <?= SubmissionHelper::getSubmissionTable($fieldData) ?>

    <?php endif; ?>

    <div class="action-buttons" style="display:none;">
        <a href="{Review_URL}" class="button primary-button">Review Submission</a>
        <a href="{Admin_Dashboard_URL}" class="button secondary-button">Go to Dashboard</a>
    </div>

<!--    <p style="height:40px;"></p>-->
</div>