<?php

use app\modules\addons\modules\stripe\models\Stripe;
use yii\helpers\Html;

/* @var $this \yii\web\View view component instance */
/* @var $message \yii\mail\MessageInterface the message being composed */
/* @var $content string main view render result */


$siteURL = (Yii::$app->params['environment'] == Stripe::LIVE ? Yii::$app->params['liveSiteURL'] : Yii::$app->params['testSiteURL']);
?>
<?php $this->beginPage() ?>


<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dar El Salam Travel - <?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333333;
            margin: 0;
            padding: 0;
            font-size:15px;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color:#06402B;
            color: white;
            padding: 20px;
            text-align: center;
        }
        .logo {
            max-width: 400px;
            margin:20px 0px;
        }
        .content {
            padding: 20px;
            background-color: #ffffff;
        }
        .details {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
            /*border-left: 4px solid #006838;*/
            border-left: 4px solid #06402B;
        }
        .package-details {
            background-color: #f8f9fa;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .important-note {
            background-color: #fff3cd;
            border-left: 4px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
        }
        .button {
            display: inline-block;
            padding: 12px 25px;
            /*background-color: #006838;*/
            background-color:#06402B;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            padding: 20px;
            font-size: 12px;
            color: #666666;
            background-color: #f8f9fa;
        }
        .social-links {
            margin: 20px 0;
        }
        .social-links a {
            margin: 0 10px;
            /*color: #006838;*/
            color:#06402B;
            text-decoration: none;
        }
        .submission_table {
            border-radius: 5px;
            border-left: 4px solid #06402B;

            border-radius: 8px;
            border: 1px solid #dddee4;
            box-shadow: 0px 1px 4px rgba(19, 126, 199, 0.2);
            border-spacing: 0;
            border-collapse: inherit;
            /*display: block;*/
            overflow-x: auto;
            overflow:hidden;
            /*white-space: nowrap;*/
            width:100%;
        }
        .submission_table * {
            /*background-color: #f8f9fa !important;*/
            /*color: black !important;*/
            font-size:14px;
        }
        .submission_table td {
            width:50%;
        }
        .submission_table th {
            padding-left: 20px !important;
        }
        .submission_table th, .submission_table td {
            padding-top: 20px !important;
            padding-bottom: 20px !important;
            font-size:14px;
        }
        .payment-table * {
            font-size:14px;
        }
        .payment-table {
            margin-top:10px;
            margin-bottom:20px;
            display:flex;
            justify-content: space-between;
        }
        .payment-table div {
            flex-grow:1;
            text-align:center;
        }
        .cta-button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #006838;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-weight: bold;
            margin: 20px 0;

        }
        .help-section {
            background-color: #fff3cd;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
            border-left: 4px solid #ffc107;
        }
        p, ul, ol, div {
            font-size:14px;
        }
        ul, ol {
            padding-left: 30px;
        }
        .btn {
            background-color:#06402B;
            color:white !important;
            text-decoration: none;
            border-radius:5px;
            padding:1rem;
        }
    </style>
</head>
<body>

<div class="container">
<!--    <div class="header">-->
<!--        <img src="--><?php //= $siteURL ?><!--static_files/uploads/app/site/thinlogowhite.png" alt="Dar El Salam Travel Logo" class="logo">-->
<!--    </div>-->

    <?php $this->beginBody() ?>
    <?= $content ?>
    <?php $this->endBody() ?>

    <div class="footer">
        <div class="social-links">
            <a href="https://www.facebook.com/DSTWorldTravel/">Facebook</a> |
            <a href="https://www.instagram.com/dstworldtravel">Instagram</a> |
            <a href="https://twitter.com/dstworldtravel">Twitter</a> |
            <a href="https://www.tiktok.com/@dstworldtravel">TikTok</a> |
            <a href="https://www.youtube.com/@dstworldtravel">YouTube</a>
        </div>
        <p>Dar El Salam Travel<br>
            280 Madison Ave #500<br>
            New York, NY 10016</p>
        <p>© 2024 Dar El Salam Travel. All rights reserved.</p>
        <p><small>This email contains important information about your travel booking. Please save it for your records.</small></p>
    </div>
</div>
</body>
</html>
<?php $this->endPage() ?>
