<?php

use app\helpers\SubmissionHelper;
use yii\web\View;
use yii\helpers\Html;

/* @var $this View */
/* @var $amount integer Dispute amount in cents */
/* @var $reason string Reason for dispute */
/* @var $evidence array Evidence details provided */
/* @var $evidence_details array Additional evidence details including due date */
/* @var $payment_method_details array Payment method information */


?>
<div class="content">
    <p>Assalamu Alaikum,</p>

    <p style="color: #d32f2f; font-weight: bold; margin-bottom: 20px;">
        ⚠️ URGENT: New Payment Dispute Received
    </p>

    <p>
        A payment dispute has been filed for a recent transaction. This requires immediate attention as we have until 
        <?= Yii::$app->formatter->asDate($evidence_details['due_by'], 'php:F j, Y') ?> to respond.
    </p>

    <div style="background: #f5f5f5; padding: 20px; margin: 20px 0; border-radius: 4px;">
        <h3 style="margin-top: 0;">Dispute Details:</h3>
        <ul style="list-style: none; padding: 0;">
            <li><strong>Amount Disputed:</strong> <?= Yii::$app->formatter->asCurrency($amount/100, 'USD') ?></li>
            <li><strong>Reason:</strong> <?= ucwords(str_replace('_', ' ', $reason)) ?></li>
            <li><strong>Customer Name:</strong> <?= Html::encode($evidence['customer_name']) ?></li>
            <li><strong>Customer Email:</strong> <?= Html::encode($evidence['customer_email_address']) ?></li>
            <li><strong>Billing Address:</strong> <?= Html::encode($evidence['billing_address']) ?></li>
            <li><strong>Card Type:</strong> <?= ucfirst($payment_method_details['card']['brand']) ?></li>
            <li><strong>Case Type:</strong> <?= ucfirst($payment_method_details['card']['case_type']) ?></li>
            <li><strong>Network Code:</strong> <?= $payment_method_details['card']['network_reason_code'] ?></li>
        </ul>
    </div>

    <p style="margin-bottom: 20px;">
        To respond to this dispute, please click the button below to access the dispute resolution center. 
        Quick action is essential to protect our funds and maintain our business relationship with the customer.
    </p>

    <div style="margin: 30px 0; text-align: center;">
        <a href="https://bookings.dstworldtravel.com/index.php?r=app%2Fform&id=h8mzYA"
           style="background: #4CAF50; color: white; padding: 12px 24px; text-decoration: none; border-radius: 4px; display: inline-block;">
            Respond to Dispute
        </a>
    </div>

    <p style="color: #666; font-size: 0.9em;">
        <strong>Important:</strong> The dispute must be addressed by 
        <?= Yii::$app->formatter->asDate($evidence_details['due_by'], 'php:F j, Y') ?>. 
        Failure to respond by this date may result in an automatic loss of the dispute.
    </p>

    <hr style="margin: 30px 0; border: 0; border-top: 1px solid #eee;">

    <p style="color: #666; font-size: 0.9em;">
        This is an automated notification. If you need assistance, please contact the IT support team.
    </p>
</div>