<?php

use app\controllers\FormController;
use app\helpers\Html;
use app\helpers\Liquid;
use app\helpers\SubmissionHelper;
use yii\web\View;

/* @var $this View view component instance */
/* @var $message string Custom Message */
/* @var $fieldValues array Submission data for replacement token */
/* @var $fieldData array Submission data for print details */
/* @var $mail_receipt_copy boolean Includes a Form Submission Copy */
/* @var $payment_type string */
/* @var $manual_payment_link string */

$message = SubmissionHelper::replaceTokens($message, $fieldValues);
$message = Liquid::render($message, $fieldValues);

?>
<div class="content">

    <div style="font-size:15px; color: #222;">
        <?= strip_tags($message, implode('', Html::allowedHtml5Tags())) ?>
    </div>

<!--    <center>-->
<!--        <a href="{Customer_Portal_URL}" class="button">Access Your Travel Portal</a>-->
<!--    </center>-->

    <?php if ($mail_receipt_copy && count($fieldData) > 0) : ?>

        <?= SubmissionHelper::getSubmissionTable($fieldData) ?>

    <?php endif; ?>

    <?php if (!empty($payment_type) && $payment_type == 'later'): ?>

        <p style="font-weight:bold;">Your reservation is not confirmed until you make a deposit or full payment. In order to make a payment, please look at one of the options below:</p>
        <ol>
            <li>
                Provide a Credit/Debit Card or ACH payment through our online portal
            </li>
        </ol>
        <table style="width:100%;text-align:center;margin:4px;"><tr><td style="padding:10px;"><a class="btn btn-primary" href="<?= $manual_payment_link ?>" title="manual payment">Manual Payment</a></td></tr></table>
        <ol start="2">
            <li>Transfer funds through Zelle using the email payments@darelsalam.com<br /><br /></li>
            <li>
                Send a Wire Transfer to Dar El Salam using the following information:<br /><br />
                Bank Name: Chase Manhattan Bank<br />
                Bank Address: 1166 Avenue of the Americas/20th Floor, New York, NY 10036<br />
                Account Name: Dar el Salam Import-Export-Travel Inc.<br />
                Account #: 898693445<br />
                Routing #: 021000021<br /><br />
            </li>
            <li>
                Mail a check to our office:<br /><br />
                Dar el Salam Travels<br />
                280 Madison Ave. Suite #500<br />
                New York, NY 10016.<br />
            </li>
        </ol>

    <?php endif; ?>

    <p>Our dedicated team is here to assist you with any questions or concerns. You can reach us at:</p>
    <ul>
        <li>Phone: 1-866-327-7252</li>
        <li>Email: info@darelsalam.com</li>
    </ul>

    <p>Best Regards,<br>Dar El Salam Travel Team</p>
</div>



<?php //if ($mail_receipt_copy && count($fieldData) > 0) : ?>
<!--    --><?php //= SubmissionHelper::getSubmissionTable($fieldData) ?>
<?php //endif; ?>
