<?php

use app\helpers\Html;
use app\helpers\Liquid;
use app\helpers\SubmissionHelper;
use yii\helpers\Url;
use yii\web\View;

/* @var $this View view component instance */
/* @var $message string Custom Message */
/* @var $fieldValues array Submission data for replacement token */
/* @var $fieldData array Submission data for print details */
/* @var $mail_receipt_copy boolean Includes a Form Submission Copy */
/* @var $form_hash_id Form Hash ID */
/* @var $instance_id Form Instance ID */

$message = SubmissionHelper::replaceTokens($message, $fieldValues);
$message = Liquid::render($message, $fieldValues);
$url = Url::to(['@web/app/form', 'id' => $form_hash_id,'instance_id' => $instance_id]);

?>
<div class="content">

    <div style="font-size:14px; color: #222;">
        <?= strip_tags($message, implode('', Html::allowedHtml5Tags())) ?>
    </div>

    <center>
        <a href="<?= $url ?>" class="cta-button" style="color:white;">Complete Your Registration</a>
    </center>

    <div class="help-section">
        <h3>Need Assistance?</h3>
        <p>Our travel specialists are here to help you complete your registration or answer any questions you may have about the package.</p>
        <ul>
            <li>Phone: 1-866-327-7252</li>
            <li>Email: info@darelsalam.com</li>
        </ul>
    </div>

    <p>Best Regards,<br>
        Dar El Salam Travel Team</p>
</div>



<?php //if ($mail_receipt_copy && count($fieldData) > 0) : ?>
<!--    --><?php //= SubmissionHelper::getSubmissionTable($fieldData) ?>
<?php //endif; ?>
