<?php

require_once 'vendor/autoload.php';
$params = require_once('config/params.php');

session_start();

$secretKey = ($params['environment'] == 'live' ? $params['stripeLiveSecretKey'] : $params['stripeTestSecretKey']);

$stripe = new \Stripe\StripeClient($secretKey, );


header('Content-Type: application/json');
try {
    // retrieve JSON from POST body
    $jsonStr = file_get_contents('php://input');
    $jsonObj = json_decode($jsonStr);

    $connected_account_id = $jsonObj->connected_account_id;


//    if ($jsonObj->setup-intent)
//
//    $customers = $stripe->customers->search([
//        'query' => 'email:"' . $jsonObj->email . '"'
//    ]);
//
//    if(count($customers->data) == 0)
//    {
//        // Get the customer ID from the cookie and the price ID from the JSON data.
//        // create the customer from the email received
//        $customer = $stripe->customers->create([
//            'email' => $jsonObj->email,
//        ]);
//    }
//    else {
//        $customer = $customers->data[0];
//    }

    $recurring = [];

//    $subsriptionLength = 0;
    $numPayments = intval($jsonObj->num_installments) - 1; // Today's is already paid so there should only be num_installments - 1 left

    if ($jsonObj->interval == 'day') {
        $recurring = ['interval' => 'day'];
    } else if ($jsonObj->interval == 'week') {
        $recurring = ['interval' => 'week'];
    } else if ($jsonObj->interval == '2weeks') {
        $recurring = ['interval' => 'week', 'interval_count' => 2];
    } else if ($jsonObj->interval == '3weeks') {
        $recurring = ['interval' => 'week', 'interval_count' => 3];
    } else if ($jsonObj->interval == '4weeks') {
        $recurring = ['interval' => 'week', 'interval_count' => 4];
    } else if ($jsonObj->interval == 'month') {
        $recurring = ['interval' => 'month'];
    }

    $setupIntent = $stripe->setupIntents->retrieve($jsonObj->setup_intent);

    $stripe->paymentMethods->attach(
        $setupIntent->payment_method,
        ['customer' => $setupIntent->customer]
    );

    $initialPriceObj = $stripe->prices->create([
        'unit_amount' => $jsonObj->amountTotal,
        'currency' => 'usd',
        'recurring' => $recurring,
        'product_data' => ['name' => 'Initial Recurring Payment'],
    ]);

    $priceObj = $stripe->prices->create([
        'unit_amount' => $jsonObj->recurringTotal,
        'currency' => 'usd',
        'recurring' => $recurring,
        'product_data' => ['name' => 'Recurring Payment'],
    ]);

    $subscription = $stripe->subscriptionSchedules->create([
        'customer' => $setupIntent->customer,
        'start_date' => 'now',
        'end_behavior' => 'cancel',
        'phases' => [
            [
                'items' => [[
                    'price' => $initialPriceObj->id,
                    'quantity' => 1,
                ]],
                'iterations' => 1,
                'application_fee_percent' => '97',
                'transfer_data' => [
                    'destination' => $connected_account_id,
//                    'amount_percent' => '97'
                ],
                'metadata' => [
                    'payment_amountSubTotal' => $jsonObj->amountSubTotal,
                    'payment_amountTotal' => $jsonObj->amountTotal,
                    'payment_recurringSubTotal' => $jsonObj->recurringSubTotal,
                    'payment_recurringTotal' => $jsonObj->recurringTotal,
                    'payment_option' => 'plan',
                    'setup_intent' => $setupIntent->id,

                ],
            ],
            [
                'items' => [[
                    'price' => $priceObj->id,
                    'quantity' => intval($jsonObj->recurringTotal) > 0 ? 1 : 0,
                ]],
                'iterations' => intval($jsonObj->num_installments) - 1,
                'application_fee_percent' => '97',
                'transfer_data' => [
                    'destination' => $connected_account_id,
//                    'amount_percent' => '97'
                ],
                'metadata' => [
                    'payment_amountSubTotal' => $jsonObj->amountSubTotal,
                    'payment_amountTotal' => $jsonObj->amountTotal,
                    'payment_recurringSubTotal' => $jsonObj->recurringSubTotal,
                    'payment_recurringTotal' => $jsonObj->recurringTotal,
                    'payment_option' => 'plan',
                    'setup_intent' => $setupIntent->id,

                ],
            ],
        ],
        'metadata' => [
            'payment_amountSubTotal' => $jsonObj->amountSubTotal,
            'payment_amountTotal' => $jsonObj->amountTotal,
            'payment_recurringSubTotal' => $jsonObj->recurringSubTotal,
            'payment_recurringTotal' => $jsonObj->recurringTotal,
            'payment_option' => 'plan',
            'payment_method' => $jsonObj->paymentMethod,
            'setup_intent' => $setupIntent->id,
        ],
        'default_settings' => [
            'default_payment_method' => $setupIntent->payment_method
        ],
//        'statement_descriptor_suffix' => 'Dar El Salam',
    ]);


    $_SESSION['subscriptionId'] = $subscription->subscription;

    $clientSecret = $subscription->latest_invoice->payment_intent->client_secret;

    // Return the subscription ID and client secret as a JSON response.
    echo json_encode([
        'subscriptionId' => $subscription->subscription,
        'clientSecret' => $clientSecret,
    ]);
} catch (Error $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

?>

