<?php

require_once 'vendor/autoload.php';
$params = require_once('config/params.php');

session_start();

$secretKey = ($params['environment'] == 'live' ? $params['stripeLiveSecretKey'] : $params['stripeTestSecretKey']);

$stripe = new \Stripe\StripeClient($secretKey, );


header('Content-Type: application/json');
try {
    // retrieve JSON from POST body
    $jsonStr = file_get_contents('php://input');
    $jsonObj = json_decode($jsonStr);

    $connected_account_id = $jsonObj->connected_account_id;

    $customers = $stripe->customers->search([
        'query' => 'email:"' . $jsonObj->email . '"'
    ]);

    if(count($customers->data) == 0)
    {
        // Get the customer ID from the cookie and the price ID from the JSON data.
        // create the customer from the email received
        $customer = $stripe->customers->create([
            'email' => $jsonObj->email,
        ]);
    }
    else
        $customer = $customers->data[0];


    $setupIntent = $stripe->setupIntents->create([
        'customer' => $customer->id,
        'payment_method_types' => ['card','us_bank_account'],
        'automatic_payment_methods' => [
            'enabled' => 'false',
        ],
        'metadata' => [
            'payment_amountSubTotal' => $jsonObj->amountSubTotal,
            'payment_amountTotal' => $jsonObj->amountTotal,
            'payment_recurringSubTotal' => $jsonObj->recurringSubTotal,
            'payment_recurringTotal' => $jsonObj->recurringTotal,
            'payment_option' => 'plan',
            'payment_method' => $jsonObj->paymentMethod,
            'payment_interval' => $jsonObj->interval,
            'payment_installments' => $jsonObj->num_installments,
            'connected_account_id' => $jsonObj->connected_account_id,
        ],
    ]);

    $clientSecret = $setupIntent->client_secret;


    echo json_encode([
        'setupIntentId' => $setupIntent->id,
        'clientSecret' => $clientSecret,
    ]);
} catch (Error $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

?>

