<?php

require_once 'vendor/autoload.php';
$params = require_once('config/params.php');

session_start();

$secretKey = ($params['environment'] == 'live' ? $params['stripeLiveSecretKey'] : $params['stripeTestSecretKey']);

$stripe = new \Stripe\StripeClient($secretKey, );


header('Content-Type: application/json');
//try {
    // retrieve JSON from POST body
    $jsonStr = file_get_contents('php://input');
    $jsonObj = json_decode($jsonStr);

    $connected_account_id = $jsonObj->connected_account_id;

    $paymentIntent = null;

    if ($paymentIntent == null) {
        $customers = $stripe->customers->search([
            'query' => 'email:"' . $jsonObj->email . '"'
        ]);

        if(count($customers->data) == 0)
        {
            // Get the customer ID from the cookie and the price ID from the JSON data.
            // create the customer from the email received
            $customer = $stripe->customers->create([
                'name' => $jsonObj->fullname,
                'email' => $jsonObj->email,
            ]);
        }
        else
            $customer = $customers->data[0];

        // Create a PaymentIntent with amount and currency
        $paymentIntent = $stripe->paymentIntents->create([
            'customer' => $customer->id,
            'amount' => $jsonObj->amountTotal,
            'currency' => 'usd',
            'metadata' => [
                'payment_subtotal' => $jsonObj->subTotal,
                'payment_total' => $jsonObj->amountTotal,
                'payment_transferred' => $jsonObj->amountTransfer ?? $jsonObj->subTotal,
                'payment_option' => 'full',
                'payment_method' => $jsonObj->paymentMethod,
            ],
            'application_fee_amount' => intval($jsonObj->amountTotal) - intval($jsonObj->amountTransfer ?? $jsonObj->subTotal),
            'transfer_data' => [
                'destination' => $connected_account_id,
//                'amount' => $jsonObj->amountTransfer ?? $jsonObj->subTotal,
            ],
            'payment_method_types' => [
                'card',
                'us_bank_account'
            ],
            'description' => $jsonObj->description,
            'statement_descriptor_suffix' => 'Dar El Salam'//$jsonObj->statement_descriptor, FIX
        ]);

        $_SESSION['paymentIntent'] = $paymentIntent->id;
    }

    $output = [
        'clientSecret' => $paymentIntent->client_secret,
    ];

    echo json_encode($output);
//} catch (Error $e) {
//    //http_response_code(500);
//    echo json_encode(['error' => $e->getMessage()]);
//}

?>

