<?php

namespace app\controllers;

use app\components\gmail\GmailService;
use app\events\PaymentSuccessEvent;
use app\helpers\EventHelper;
use app\helpers\MailHelper;
use app\models\FormConfirmation;
use app\models\StripeWebhook;
use app\modules\addons\modules\emailoctopus\models\EmailOctopus;
use app\modules\addons\modules\stripe\models\Stripe;
use app\modules\addons\modules\stripe\models\StripePayment;
use app\modules\addons\modules\stripe\services\StripeService;
use DateTime;
use Google_Service_Gmail_Message;
use kartik\mpdf\Pdf;
use PhpParser\Node\Expr\Cast\Double;
use Stripe\Charge;
use Stripe\Invoice;
use Stripe\PaymentIntent;
use Stripe\SetupIntent;
use Stripe\StripeClient;
use Stripe\Transfer;
use Yii;
use yii\data\ArrayDataProvider;
use yii\db\IntegrityException;
use yii\grid\GridView;
use yii\helpers\Json;
use Spipu\Html2Pdf\Html2Pdf;

use app\vendor\QuickChart\QuickChart;
use yii\helpers\Url;

class WebhookController extends \yii\web\Controller
{
    public $layout = false;

    public static function allowedDomains() {
        return [
            '*',                        // star allows all domains
//            'https://dev..com',
        ];
    }

    /**
     * @inheritdoc
     */
    public function behaviors() {
        return array_merge(parent::behaviors(), [

            // For cross-domain AJAX request
            'corsFilter'  => [
                'class' => \yii\filters\Cors::className(),
                'cors'  => [
                    // restrict access to domains:
                    'Origin'                           => static::allowedDomains(),
                    'Access-Control-Request-Method'    => ['POST'],
                    'Access-Control-Allow-Credentials' => true,
                    'Access-Control-Max-Age'           => 3600,                 // Cache (seconds)
                ],
            ],

        ]);
    }

    public function beforeAction($action)
    {
        $this->enableCsrfValidation = false;
        return parent::beforeAction($action);
    }


    public function actionQuery($question, $accountID) {
//        $user = \Da\User\Model\User::findOne(['id' => Yii::$app->user->id]);
//        $account = Account::findOne(['accountID' => $user->accountID]);


        $data = [
            'question' => $question,
        ];

        $jsonData = json_encode($data);

        $curl = curl_init();

        curl_setopt_array($curl, [
            CURLOPT_URL => 'https://ai-template.onrender.com/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => $jsonData,
            CURLOPT_HTTPHEADER => [
                'Content-Type:application/json',
            ],
        ]);

        $response = curl_exec($curl);

        curl_close($curl);

        $aiResponse = new AIResponses();
        $aiResponse->question = $question;
        $aiResponse->response = $response;
        $aiResponse->created = time();
        $aiResponse->accountID = $accountID;

        $aiResponse->save(false);

        $responseData = json_decode($response, true);

//        print_r($responseData);
        $output = $responseData['output'];
//        $jsonPos = strpos($output, '{');
//
//        if ($jsonPos === false)
//            return Json::encode(['response' => nl2br($output)]);

//        $responseTxt = substr($output, 0, $jsonPos);
//        $responseJson = substr($output, $jsonPos);
//        $responseJson = str_replace('```json', '', $responseJson);
//        $responseJson = trim($responseJson, ' `');
        $responseTxt = '';
        $responseJson = '';

//        echo $output;

        // search for json rows first

        $start = strpos($output, '{');
        $end = strrpos($output, '}');

        if ($start !== false) { // it is a table of json rows
            $responseTxt = substr($output, 0, $start);
            $responseJson = substr($output, $start, $end - $start + 1);

//            echo 'responseTxt' . $responseTxt . '<br /><br />';
//            echo 'responseJson' . $responseJson . '<br/ ><br />';


            $decodedJson = json_decode($responseJson);


            if (!empty($decodedJson->TYPE) && ($decodedJson->TYPE == 'LINE' || $decodedJson->TYPE == 'BAR')) {
                $type = strtolower($decodedJson->TYPE);

                $responseJson = str_replace('TYPE', 'type', $responseJson);
                $responseJson = str_replace('BAR', 'bar', $responseJson);
                $responseJson = str_replace('LINE', 'line', $responseJson);

                return Json::encode(['response' => nl2br($responseTxt), 'json' => $responseJson, 'jsonHtml' => '', 'type' => $type]);
            }

            if (!empty($decodedJson->TYPE) && $decodedJson->TYPE == 'TABLE') {


                $type = 'table';
                $grid = '';
                $provider = new ArrayDataProvider([
                    'allModels' => $decodedJson->data,
                    'pagination' => false,
                ]);

                $grid = GridView::widget([
                    'dataProvider' => $provider,
                    'tableOptions' => ['class' => 'table', 'style' => 'margin-top:20px;'],
                    'layout' => '{items}{pager}{summary}',
                    'pager' => ['linkOptions' => ['class' => 'button']],
                ]);

                return Json::encode(['response' => nl2br($responseTxt), 'json' => $responseJson, 'jsonHtml' => $grid, 'type' => $type]);
            }

//            print_r($decodedJson);

            return Json::encode(['response' => nl2br($responseTxt), 'json' => $responseJson, 'jsonHtml' => '<ul>' .  self::build_list($decodedJson) . '</ul>', 'type' => 'json']);
        }

        return Json::encode(['response' => nl2br(trim($output, '`'))]);

    }


    public function actionConfirm() {

        if (Yii::$app->params['environment'] === 'sandbox') {
            $publishableKey = Yii::$app->params['stripeSandboxPublishableKey'];
            $secretKey = Yii::$app->params['stripeSandboxSecretKey'];
        }
        else {
            $publishableKey = Yii::$app->params['stripeLivePublishableKey'];
            $secretKey = Yii::$app->params['stripeLiveSecretKey'];
        }

        if (!empty(Yii::$app->request->get('code'))) {
            \Stripe\Stripe::setApiKey($secretKey);

            $response = \Stripe\OAuth::token([
                'grant_type' => 'authorization_code',
                'code' => Yii::$app->request->get('code'),
            ]);

            // Access the connected account id in the response
            $connected_account_id = $response->stripe_user_id;
            $content = 'connected_acount_id: ' . $connected_account_id . '<br />';


            $user = \Da\User\Model\User::findOne(['id' => Yii::$app->user->id]);
            $accountModel = Account::findOne(['accountID' => $user->accountID]);
            $accountModel->connected_account_id = $connected_account_id;

            $accountModel->save(false);

            $content .= 'successfully confirmed account';

            Yii::$app->session->setFlash(
                'success',
                Yii::t('app', 'Successfully Connected Account to ' . Yii::$app->params['applicationName'] . '!')
            );
        } else {
            Yii::$app->session->setFlash(
                'warning',
                Yii::t('app', 'Unable to Connect Account to Swift Give.')
            );
        }


        return $this->redirect(['//account/paymentprocessor']);
    }


    public function actionPercentage() {
        $connected_account_id = Yii::$app->request->get()['connected_account_id'];
        $account = Account::findOne(['connected_account_id' => $connected_account_id]);

        include($_SERVER['DOCUMENT_ROOT'].'/calculateFee.php');

        $tier = $account->pricing_tier;

        $percentage = calculateFee($account->accountID, 'kiosk');

        $params = Yii::$app->params;
        if ($params['environment'] === 'sandbox') {
            $siteURL = $params['sandboxURL'];
        }
        else {
            $siteURL = $params['liveURL'];
        }

        return Json::encode([$percentage, $account->widget_text_color ?? '', $account->widget_background_color ?? '', !empty($account->tablet_logo) ?  $siteURL . '/basic/uploads/' . $account->tablet_logo : '', !empty($account->tablet_background) ? $siteURL . '/basic/uploads/' . $account->tablet_background : '', $account->heading_text ?? '', $account->heading_text_color ?? '']);
//        return $percentage;
    }

    public function sendEmail($emailModel, $campaign_id, $designation, $interval, $paymentMethod, $customer_name, $customer_email, $customer_id, $amount, $accountID) {

        $campaign = Campaign::findOne(['campaign_id' => $campaign_id]);
        if ($campaign == null)
            return;

        $campaign_name = $campaign->campaign_name;
        $account = Account::findOne(['accountID' => $accountID]);
        $org_name = $account->org_name;

        $intervalText = $interval;
        if ($interval == 'day')
            $intervalText = 'Daily';
        else if ($interval == 'week')
            $intervalText = 'Weekly';
        else if ($interval == 'month')
            $intervalText = 'Monthly';
        else if ($interval == 'year')
            $intervalText = 'Annually';

        $emailSubject = $emailModel->subject;
        $emailSubject = str_replace('{payment_method}', $paymentMethod, $emailSubject);
        $emailSubject = str_replace('{org_name}',$org_name, $emailSubject);
        $emailSubject = str_replace('{campaign_name}',$campaign_name, $emailSubject);
        $emailSubject = str_replace('{designation}',$designation, $emailSubject);
        $emailSubject = str_replace('{amount}',Yii::$app->formatter->asCurrency($amount), $emailSubject);
        $emailSubject = str_replace('{donor_name}',$customer_name, $emailSubject);
        $emailSubject = str_replace('{interval}',$intervalText, $emailSubject);
//        $emailSubject = str_replace('{date}', Yii::$app->formatter->asDate(time(), 'php:F j, Y h:i a'), $emailSubject);

        $emailBody = $emailModel->body;
        $emailBody = str_replace('{payment_method}',$paymentMethod, $emailBody);
        $emailBody = str_replace('{org_name}',$org_name, $emailBody);
        $emailBody = str_replace('{campaign_name}',$campaign_name, $emailBody);
        $emailBody = str_replace('{designation}',$designation, $emailBody);
        $emailBody = str_replace('{amount}',Yii::$app->formatter->asCurrency($amount), $emailBody);
        $emailBody = str_replace('{donor_name}',$customer_name, $emailBody);
        $emailBody = str_replace('{interval}',$intervalText, $emailBody);
//        $emailBody = str_replace('{date}', Yii::$app->formatter->asDate(time(), 'php:F j, Y h:i a'), $emailBody);


        $css = '<style type="text/css">
                    p {
                        margin:0px;
                        margin-block:0px;
                    }
                </style>';

        if (!empty($customer_email)) {
            Yii::$app->mailer->compose('layouts/html', ['content' => $css . $emailBody])
                ->setFrom([Yii::$app->params['adminEmail'] => 'Swift Give'])
                ->setTo($customer_email)
                ->setSubject($emailSubject)
                ->send();

            $emailHistory = new EmailHistory();
            $emailHistory->sent = time();
            $emailHistory->toEmail = $customer_email;
            $emailHistory->fromEmail = Yii::$app->params['adminEmail'];
            $emailHistory->subject = $emailSubject;
            $emailHistory->body = $css . $emailBody;
            $emailHistory->customer_id = $customer_id;

            $emailHistory->save(false);
        }
    }

    public function sendAdminEmail($emailModel, $campaign_id, $designation, $interval, $paymentMethod, $customer_name, $amount, $accountID) {

        $campaign = Campaign::findOne(['campaign_id' => $campaign_id]);
        if ($campaign == null)
            return;

        if (!$campaign->admin_emails)
            return;

        $campaign_name = $campaign->campaign_name;
        $account = Account::findOne(['accountID' => $accountID]);
        $org_name = $account->org_name;

        $intervalText = $interval;
        if ($interval == 'day')
            $intervalText = 'Daily';
        else if ($interval == 'week')
            $intervalText = 'Weekly';
        else if ($interval == 'month')
            $intervalText = 'Monthly';
        else if ($interval == 'year')
            $intervalText = 'Annually';

        $emailSubject = $emailModel->subject;
        $emailSubject = str_replace('{payment_method}', $paymentMethod, $emailSubject);
        $emailSubject = str_replace('{org_name}',$org_name, $emailSubject);
        $emailSubject = str_replace('{campaign_name}',$campaign_name, $emailSubject);
        $emailSubject = str_replace('{designation}',$designation, $emailSubject);
        $emailSubject = str_replace('{amount}',Yii::$app->formatter->asCurrency($amount), $emailSubject);
        $emailSubject = str_replace('{donor_name}',$customer_name, $emailSubject);
        $emailSubject = str_replace('{interval}',$intervalText, $emailSubject);

        $emailBody = $emailModel->body;
        $emailBody = str_replace('{payment_method}',$paymentMethod, $emailBody);
        $emailBody = str_replace('{org_name}',$org_name, $emailBody);
        $emailBody = str_replace('{campaign_name}',$campaign_name, $emailBody);
        $emailBody = str_replace('{designation}',$designation, $emailBody);
        $emailBody = str_replace('{amount}',Yii::$app->formatter->asCurrency($amount), $emailBody);
        $emailBody = str_replace('{donor_name}',$customer_name, $emailBody);
        $emailBody = str_replace('{interval}',$intervalText, $emailBody);

        Yii::$app->mailer->compose('layouts/adminDonationNotification', ['content' => $emailBody])
            ->setFrom([Yii::$app->params['adminEmail'] => 'Swift Give'])
            ->setTo($account->contact_email)
            ->setSubject($emailSubject)
            ->send();
    }

    public function actionSendautomatedemail() {
        $content = '';

        $user = \Da\User\Model\User::findOne(['id' => Yii::$app->user->id]);
        $account = Account::findOne(['accountID' => $user->accountID]);

        $reports = Reports::findAll(['accountID' => $user->accountID, 'status' => 1]);

        $currentDate = (new DateTime('now'))->modify('+355 day');

        $content .= 'Current Date ' . Yii::$app->formatter->asDate($currentDate, 'php:m/d/Y, h:i a') . '<br /><br />';


        foreach($reports as $report) {

            $date_diff = floor(abs($currentDate->getTimestamp() - $report->created) / 86400);

            $content .= 'Report Created Date: ' . Yii::$app->formatter->asDate($report->created, 'php:m/d/Y, h:i a') . '<br />';
            $content .= 'Frequency: ' . $report->frequency . '<br />';
            $content .= 'Date Difference: ' . $date_diff . '<br />';

            // Daily, Weekly, Monthly, Yearly

            if ($report->frequency == 'Daily' && $date_diff != 0 && $date_diff % 1 == 0) { // Daily
                $this->sendReportPDF($report);
                $content .= 'Sent Daily Report<br />';
            }

            if ($report->frequency == 'Weekly' && $date_diff != 0 && $date_diff % 7 == 0) {
                $this->sendReportPDF($report);
                $content .= 'Sent Weekly Report<br />';
            }

            if ($report->frequency == 'Monthly' && $date_diff != 0 && $date_diff % 30 == 0) {
                $this->sendReportPDF($report);
                $content .= 'Sent Monthly Report<br />';
            }

            if ($report->frequency == 'Yearly' && $date_diff != 0 && $date_diff % 365 == 0) {
                $this->sendReportPDF($report);
                $content .= 'Sent Yearly Report<br />';
            }

            $content .= '<br />';
        }

        return $content;
    }

    public function actionIndex()
    {
        $siteURL = (Yii::$app->params['environment'] == \app\modules\addons\modules\stripe\models\Stripe::LIVE ? Yii::$app->params['liveSiteURL'] : Yii::$app->params['testSiteURL']);

        $endpoint_secret = (Yii::$app->params['environment'] == \app\modules\addons\modules\stripe\models\Stripe::LIVE ? Yii::$app->params['stripeLiveWebhookKey'] : Yii::$app->params['stripeTestWebhookKey']);
        $secretKey = (Yii::$app->params['environment'] == \app\modules\addons\modules\stripe\models\Stripe::LIVE ? Yii::$app->params['stripeLiveSecretKey'] : Yii::$app->params['stripeTestSecretKey']);

        $stripe = new StripeClient($secretKey);

        $payload = @file_get_contents('php://input');
        $sig_header = $_SERVER['HTTP_STRIPE_SIGNATURE'];
        $event = null;

        $content = '';

        try {
            $event = \Stripe\Webhook::constructEvent(
                $payload, $sig_header, $endpoint_secret
            );
            
            // Save webhook data
            $webhook = new StripeWebhook();
            $webhook->event_type = $event->type;
            $webhook->event_id = $event->id;
            $webhook->object_id = $event->data->object->id;
            $webhook->object_data = json_encode($event->data->object);
            $webhook->created_at = time();
            $webhook->save(false);

        } catch(\UnexpectedValueException $e) {
            // Invalid payload
            http_response_code(400);
            exit();
        } catch(\Stripe\Exception\SignatureVerificationException $e) {
            // Invalid signature
            http_response_code(400);
            exit();
        } catch (IntegrityException $e) {
            $content .= 'already registered webhook';
        }

        // Check if event has payment intent and search for it
        if (!empty($event->data->object->payment_intent)) {
            $paymentIntent = $event->data->object->payment_intent;

            if (str_starts_with($event->type, 'invoice') && !empty($event->data->object->subscription))
                $payment = StripePayment::findOne(['subscription_id' => $event->data->object->subscription]);
            else
                $payment = StripePayment::findOne(['payment_id' => $paymentIntent]);
            
            if (empty($payment)) {
                $gmailService = new GmailService();
                $msg = $gmailService->createMessage(
                    ['noreply@darelsalam.com' => 'Dar El Salam'],
                    ['sohaibsheikh@gmail.com'],
                    '',
                    '',
                    '',
                    'Payment Intent Not Found',
                    'Payment intent ' . $paymentIntent . ' from webhook event ' . $event->type . ' was not found in the system.'
                );
                $gmailService->sendMessage($msg);
                $content .= 'Sent email about missing payment intent';
            }
        }

        // Handle the event
        switch ($event->type) {
            case 'charge.dispute.created':
                $settings = Yii::$app->settings;
                $dispute = $event->data->object;

//                $service = new GmailService();
                $fromEmail = MailHelper::from($settings->get("app.noreplyEmail"));
                $toEmail = [
                    'dev@darelsalam.com',
                    'abdullah.jangda@gmail.com',
                    'zahra@darelsalam.com'
                ];
                $replyToEmail = '';
                $cc = '';
                $bcc = '';
                $subject = 'New Travel Dispute';

                Yii::$app->controller->layout = false;
                // Pass the dispute object data to the view
                $output = Yii::$app->controller->render('@app/mail/dispute-html', [
                    'amount' => $dispute->amount,
                    'reason' => $dispute->reason,
                    'evidence' => $dispute->evidence,
                    'evidence_details' => $dispute->evidence_details,
                    'payment_method_details' => $dispute->payment_method_details,
                ]);
                $body = Yii::$app->controller->render('@app/mail/layouts/html', ['content' => $output, 'message' => '']);


                $gmailService = new GmailService();
                $msg = $gmailService->createMessage(
                    ['noreply@darelsalam.com' => 'Dar El Salam'],
                    $toEmail,
                    '',
                    '',
                    '',
                    $subject,
                    $body,
                );
                $gmailService->sendMessage($msg);

//                $message = $service->createMessage($fromEmail, $toEmail, $replyToEmail, $cc, $bcc, $subject, $body);
//                $content .= print_r($message, true);
//                $message2 = new Google_Service_Gmail_Message();
//                $content .= $service->sendMessage($message2);

                break;
            case 'transfer.created':
                /** @var Transfer $transfer */
                $transfer = $event->data->object;

                $updatedTransfer = $stripe->transfers->update(
                    $transfer->id,
                    ['description' => 'Test Description']
                );

                $content .= print_r($updatedTransfer, true);

                break;
            case 'payment_intent.requires_action':
                /** @var PaymentIntent $paymentIntent */
                $paymentIntent = $event->data->object;

                if(!empty($paymentIntent->next_action) && $paymentIntent->next_action->type == 'verify_with_microdeposits') {
                    $content .= 'verify with microdeposits';


                    $customer = $stripe->customers->retrieve($paymentIntent->customer);


                    $response = MailHelper::sendPaymentVerificationByEmail($customer->email, $paymentIntent->next_action->verify_with_microdeposits->hosted_verification_url);
                    $content .= print_r($response, true);
                }


                break;
            case 'setup_intent.requires_action':
                /** @var SetupIntent $setupIntent */
                $setupIntent = $event->data->object;

                if(!empty($setupIntent->next_action) && $setupIntent->next_action->type == 'verify_with_microdeposits') {
                    $content .= 'verify with microdeposits';


                    $customer = $stripe->customers->retrieve($setupIntent->customer);


                    $response = MailHelper::sendPaymentVerificationByEmail($customer->email, $setupIntent->next_action->verify_with_microdeposits->hosted_verification_url);
                    $content .= print_r($response, true);
                }


                break;
            case 'setup_intent.succeeded':
                /** @var SetupIntent $setupIntent */
                $setupIntent = $event->data->object;
                $customer = $stripe->customers->retrieve($setupIntent->customer);
//                $content .= print_r($setupIntent->metadata, true);

                $data = [
                    'amountSubTotal' => $setupIntent->metadata->payment_amountSubTotal,
                    'amountTotal' => $setupIntent->metadata->payment_amountTotal,
                    'recurringSubTotal' => $setupIntent->metadata->payment_recurringSubTotal,
                    'recurringTotal' => $setupIntent->metadata->payment_recurringTotal,
                    'email' => $customer->email,
                    'fullname' => $customer->name,
                    'statement_descriptor' => 'Dar El Salam',
                    'interval' => $setupIntent->metadata->payment_interval,
                    'num_installments' => $setupIntent->metadata->payment_installments,
                    'setup_intent' => $setupIntent->id,
                    'connected_account_id' => $setupIntent->metadata->connected_account_id
                ];

                $jsonData = json_encode($data);

                $curl = curl_init();

                curl_setopt_array($curl, [
                    CURLOPT_URL => $siteURL . 'create-subscription.php',
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => '',
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => 'POST',
                    CURLOPT_POSTFIELDS => $jsonData,
                    CURLOPT_HTTPHEADER => [
                        'Content-Type:application/json',
                    ],
                ]);

                $response = curl_exec($curl);

                curl_close($curl);

                $content .= print_r($response, true);

                $resonseJson = json_decode($response);

                sleep(10);

                if ($resonseJson->subscriptionId) {
                    $content .= 'saving subscription id' . $resonseJson->subscriptionId;

                    StripePayment::updateAll(['status' => 'Scheduled', 'subscription_id' => $resonseJson->subscriptionId],['payment_id' => $setupIntent->id]);
                }

                break;
            case 'invoice.created':
                $invoice = $event->data->object;

                if (!empty($invoice) &&
                    !empty($invoice->subscription_details) &&
                    !empty($invoice->subscription_details->metadata) &&
                    !empty($invoice->subscription_details->metadata->payment_amountSubTotal) &&
                    !empty($invoice->subscription_details->metadata->payment_amountTotal) &&
                    $invoice->amount_due == $invoice->subscription_details->metadata->payment_amountTotal) {

                    $updatedInvoice = $stripe->invoices->update($invoice->id, [
                        'statement_descriptor' => 'Dar El Salam',
                        'application_fee_amount' => intval($invoice->subscription_details->metadata->payment_amountTotal) - intval($invoice->subscription_details->metadata->payment_amountSubTotal),
                        'transfer_data' => [
//                                'amount' => $invoice->subscription_details->metadata->payment_amountSubTotal,
                            'destination' => $invoice->transfer_data->destination
                        ]
                    ]);

                    $content .= 'updated original invoice';

                    $content .= 'Successfully updated amount for invoice transfer';
                }

                if (!empty($invoice) &&
                    !empty($invoice->subscription_details) &&
                    !empty($invoice->subscription_details->metadata) &&
                    !empty($invoice->subscription_details->metadata->payment_recurringSubTotal) &&
                    !empty($invoice->subscription_details->metadata->payment_recurringTotal) &&
                    $invoice->amount_due == $invoice->subscription_details->metadata->payment_recurringTotal) {
                    $updatedInvoice = $stripe->invoices->update($invoice->id, [
                        'statement_descriptor' => 'Dar El Salam',
                        'application_fee_amount' => intval($invoice->subscription_details->metadata->payment_recurringTotal) - intval($invoice->subscription_details->metadata->payment_recurringSubTotal),
                        'transfer_data' => [
//                                'amount' => $invoice->subscription_details->metadata->payment_recurringSubTotal,
                            'destination' => $invoice->transfer_data->destination
                        ]
                    ]);

                    $content .= 'updated recurring invoice';
                }

                $content .= print_r($updatedInvoice, true);
                break;
            case 'charge.failed':
                /** @var Charge $charge */
                $charge = $event->data->object;


                if ($charge->invoice == null) { // One-Time Charge
                    $payment = StripePayment::findOne(['payment_id' => $charge->payment_intent]);
                    $customer = $stripe->customers->retrieve($charge->customer);

                    if(!empty($payment)) {
                        $payment->status = 'Failed';
                        $payment->save();

                        $content .= 'sending failed payment email';

                        $session = $stripe->billingPortal->sessions->create([
                            'customer' => $customer->id,
                        ]);

//                        $manualPaymentLink = FormController::generateManualCheckout($payment->submission_id);

                        $response = MailHelper::sendPaymentFailureByEmail($customer->email, $session->url );
                        $content .= print_r($response, true);
                    }
                    else {
                        $content .= 'could not find payment ' . $charge->payment_intent;
                    }
                }
                else { // Recurring Charge
                    /** @var Invoice $invoice */
                    $invoice = $stripe->invoices->retrieve($charge->invoice);

                    $content .= $charge->invoice . '<br />';
                    $content .= $invoice->subscription . '<br />';
                    $content .= $charge->amount . '<br />';
                    $content .= $invoice->subscription_details->metadata->setup_intent . '<br />';

                    /** @var StripePayment $payment */
                    $payment = StripePayment::find()
                        ->andFilterWhere(['payment_id' => $invoice->subscription_details->metadata->setup_intent])
                        ->andFilterWhere(['total' => $charge->amount])
                        ->andFilterWhere(['in', 'status', ['Scheduled','Failed','Processing']])
                        ->orderBy('id ASC')
                        ->one();
                    $customer = $stripe->customers->retrieve($charge->customer);

//                    $content .= print_r($payment, true);

                    if(!empty($payment) && !empty($customer)) {
                        $payment->status = 'Failed';
                        $payment->save();


                        $session = $stripe->billingPortal->sessions->create([
                            'customer' => $customer->id,
                        ]);

                        $content .= 'sending failed payment email';
                        $response = MailHelper::sendPaymentFailureByEmail($customer->email, $session->url);
                        $content .= print_r($response, true);
                    }
//                    else if (!empty($payment)) {
//                        $payment->status = 'Failed';
//                        $payment->save();
//
//                        $content .= 'sending failed payment email w/ no customer';
//
//                        $response = MailHelper::sendPaymentFailureByEmail($customer->email, $session->url);
//                        $content .= print_r($response, true);
//                    }
                    else {
                        $content .= 'could not find customer or payment ' . $charge->payment_intent;
                    }
                }

                break;
            case 'charge.pending':
                /** @var Charge $charge */
                $charge = $event->data->object;

                if ($charge->invoice == null) { // One-Time Charge
                    $payment = StripePayment::findOne(['payment_id' => $charge->payment_intent]);

                    if(!empty($payment)) {
                        $payment->status = 'Processing';
                        $payment->save();

                        $content .= 'sending pending payment email';
//                        $response = MailHelper::sendPaymentConfirmationByEmail($payment);
                    }
                    else {
                        $content .= 'could not find payment ' . $charge->payment_intent;
                    }
                }
                else { // Recurring Charge
                    /** @var Invoice $invoice */
                    $invoice = $stripe->invoices->retrieve($charge->invoice);

                    $content .= $charge->invoice . '<br />';
                    $content .= $invoice->subscription . '<br />';
                    $content .= $charge->amount . '<br />';
                    $content .= $invoice->subscription_details->metadata->setup_intent . '<br />';

                    $payment = StripePayment::find()
                        ->andFilterWhere(['payment_id' => $invoice->subscription_details->metadata->setup_intent])
                        ->andFilterWhere(['total' => $charge->amount])
                        ->andFilterWhere(['in', 'status', ['Scheduled','Failed','Processing']])
                        ->orderBy('id ASC')
                        ->one();

                    if(!empty($payment)) {
                        $payment->status = 'Processing';
                        $payment->save();

//                        $response = MailHelper::sendPaymentConfirmationByEmail($payment);
                    }
                }

                break;
            case 'charge.refunded':
                $charge = $event->data->object;

                $payment = StripePayment::findOne(['payment_id' => $charge->payment_intent]);

                if(!empty($payment)) {
                    $payment->refunded_amount = $charge->amount_refunded;

                    if ($charge->amount == $charge->amount_refunded) { 
                        $payment->status = 'Refunded';
                    }
                    else {
                        $payment->status = 'Partially Refunded';
                    }

                    
                    $payment->save();

                    // send refunded email?
                }

                break;
            case 'charge.succeeded':
                /** @var Charge $charge */

                $charge = $event->data->object;
                $charge->payment_intent;

                $content .= 'charge: ' . $charge->id;
                $content .= 'payment intent: ' . $charge->payment_intent;

                sleep(10);


                if ($charge->invoice == null) { // One-Time Charge
                    $payment = StripePayment::findOne(['payment_id' => $charge->payment_intent]);

                    $event = new PaymentSuccessEvent();
                    $event->payment = $payment;

//                    $this->trigger(EventHelper::EVENT_STRIPE_PAYMENT_RECEIVED, $event);


                    if(!empty($payment)) {
                        if (!empty($charge->transfer_data->amount))
                            $payment->transfer_amount = $charge->transfer_data->amount;

                        if (!empty($charge->amount) && !empty($charge->application_fee_amount))
                            $payment->transfer_amount = intval($charge->amount) - intval($charge->application_fee_amount);

                        $content .= 'transfer_amount: ' . $payment->transfer_amount;

                        if ($payment->status == 'Complete')
                        {
                            $payment->save();
                            $content .= 'payment already confirmed and email sent';
                        }
                        else
                        {
                            $payment->status = 'Complete';
                            $payment->save();

                            $content .= 'sending payment confirmation';

                            $response = MailHelper::sendPaymentConfirmationByEmail($payment);

                            $this->trigger(EventHelper::EVENT_STRIPE_PAYMENT_RECEIVED, $event);
                        }
                    }
                    else {
                        $paymentIntent = $stripe->paymentIntents->retrieve($charge->payment_intent);
                        $customer = $stripe->customers->retrieve($charge->customer);

                        $payment = new StripePayment();
                        $payment->form_id = 0;
                        $payment->stripe_id = 0;
                        $payment->submission_id = 0;
                        $payment->payment_id = $paymentIntent->id;
                        $payment->amount = !empty($paymentIntent->amount) ? number_format($paymentIntent->amount / 100, 2) : null;
                        $payment->customer_name = $customer->name;
                        $payment->customer_email = $customer->email;
                        $payment->subtotal = $charge->metadata->payment_subtotal;
                        $payment->fees = intval($paymentIntent->amount) - intval($charge->metadata->payment_subtotal);
                        $payment->discount = 0;
                        $payment->total = $paymentIntent->amount;
                        $payment->currency = $paymentIntent->currency;
                        $payment->receipt_email = $paymentIntent->receipt_email;
                        $payment->fullOrPartial = 'manual';
                        $payment->created_at = strtotime('now');
                        $payment->status = 'Complete';

                        $payment->created_by = $charge->metadata->created_by ?? 172;

//                        if (!empty($formModel) && !empty($formModel->created_by)) {
//                            $payment->created_by = $formModel->created_by;
//                        }
//                        else
//                            $payment->created_by = $json_data->account_id;

                        if (!empty($charge)) {
                            $payment->payment_method = isset($charge->payment_method_details->type) ? $charge->payment_method_details->type : null;
                            if ($payment->payment_method == 'card') {
                                $payment->brand = isset($charge->payment_method_details->card->brand) ? $charge->payment_method_details->card->brand : null;
                                $payment->last4 = isset($charge->payment_method_details->card->last4) ? $charge->payment_method_details->card->last4 : null;
                                $payment->country = isset($charge->payment_method_details->card->country) ? $charge->payment_method_details->card->country : null;
                            } else if ($payment->payment_method == 'us_bank_account') {
                                $payment->brand = isset($charge->payment_method_details->us_bank_account->bank_name) ? $charge->payment_method_details->us_bank_account->bank_name : null;
                                $payment->last4 = isset($charge->payment_method_details->us_bank_account->last4) ? $charge->payment_method_details->us_bank_account->last4 : null;
                            }
                        }


                        $payment->save(false);


                        MailHelper::sendManualPaymentConfirmationByEmail($payment);

                        $content .= 'could not find payment because payment was processed before form submission fully went through';
                    }
                }
                else { // Recurring Charge
                    $invoice = $stripe->invoices->retrieve($charge->invoice);

                    $content .= $charge->invoice . '<br />';
                    $content .= $invoice->subscription . '<br />';
                    $content .= $charge->amount . '<br />';
                    $content .= $invoice->subscription_details->metadata->setup_intent . '<br />';

                    /** @var StripePayment $payment */
                    $payment = StripePayment::find()
                        ->andFilterWhere(['payment_id' => $invoice->subscription_details->metadata->setup_intent])
                        ->andFilterWhere(['total' => $charge->amount])
                        ->andFilterWhere(['in', 'status', ['Scheduled','Failed','Processing']])
                        ->orderBy('id ASC')
                        ->one();

                    $event = new PaymentSuccessEvent();
                    $event->payment = $payment;

                    if(!empty($payment)) {
                        if (!empty($charge->transfer_data->amount))
                            $payment->transfer_amount = $charge->transfer_data->amount;
                        if (!empty($charge->amount) && !empty($charge->application_fee_amount))
                            $payment->transfer_amount = intval($charge->amount) - intval($charge->application_fee_amount);

                        $payment->payment_id = $charge->payment_intent;
                        $payment->setup_id = $invoice->subscription_details->metadata->setup_intent;
                        $payment->subscription_id = $invoice->subscription;

                        $payment->status = 'Complete';
                        $payment->save();

                        $content .= 'sending payment confirmation';

                        $response = MailHelper::sendPaymentConfirmationByEmail($payment);

                        $this->trigger(EventHelper::EVENT_STRIPE_PAYMENT_RECEIVED, $event);
                    }
                }

                break;
            case 'payout.created':
                $payout = $event->data->object;

                $balanceTransactions = $stripe->balanceTransactions->all([
                    'payout' => $payout->id,
                    'expand' => ['data.source'],
                    'limit' => 30,
                ]);

                $content .= print_r($balanceTransactions, true);
                break;
            default:
                $content .= 'Received unknown event type ' . $event->type;
        }

        return $this->render('index', ['content' => $content]);
    }

}
