<?php

namespace app\components\gmail;

use Google\Service\Gmail\Message;
use Google_Client;
use Google_Service_Gmail;
use Google_Service_Gmail_Message;
use Swift_Attachment;
use Yii;

/**
 *
 */
class GmailService
{
    protected $user_to_impersonate = 'noreply@darelsalam.com';
    protected $gmailService;
    public function __construct() {
        $sender = $this->user_to_impersonate;

        // The path to your service account credentials goes here.
        putenv("GOOGLE_APPLICATION_CREDENTIALS=dst-credentials.json");

        $client = new Google_Client();
        $client->useApplicationDefaultCredentials();
        $client->setSubject($sender);
        $client->setApplicationName("Dar El Salam");
        $client->setScopes(["https://mail.google.com/",
            "https://www.googleapis.com/auth/gmail.compose",
            "https://www.googleapis.com/auth/gmail.modify",
            "https://www.googleapis.com/auth/gmail.send"]);
        $this->gmailService = new Google_Service_Gmail($client);
    }

    /**
     * @param $msg
     * @return mixed
     */
    function sendMessage($msg)
    {
        $sender = $this->user_to_impersonate;
        $message = new Message();
        return $this->gmailService->users_messages->send($sender, $msg);
    }

    /**
     * @param $from
     * @param $to
     * @param $replyTo
     * @param $cc
     * @param $bcc
     * @param $subject
     * @param $messageText
     * @param $attachment
     * @return Google_Service_Gmail_Message
     */
    function createMessage($from, $to, $replyTo, $cc, $bcc, $subject, $messageText, $attachment = null)
    {
        $message = new \Swift_Message();

        if ($attachment != null)
            $message->attach($attachment);

        $message->setFrom($from);
        $message->setTo($to);
        if(!empty($replyTo))
            $message->setReplyTo($replyTo);
        if(!empty($cc))
            $message->setCc($cc);
        if(!empty($bcc))
            $message->setBcc($bcc);
        $message->setBody($messageText, 'text/html');
        $message->setSubject($subject);
        $gmailMsg = new Google_Service_Gmail_Message();

        $gmailMsg->setRaw(strtr(base64_encode($message->toString()), array('+' => '-', '/' => '_')));

        return $gmailMsg;




        $sender = $this->user_to_impersonate;
        $rawMsgStr = "From: \"Dar El Salam\" <{$sender}>\r\n";
        $rawMsgStr .= "To: <{$to}>\r\n";
        $rawMsgStr .= 'Subject: =?utf-8?B?' . base64_encode($subject) . "?=\r\n";
        if(!empty($replyTo))
            $rawMsgStr .= "Reply-To: <{$replyTo}>\r\n";
        if(!empty($cc))
            $rawMsgStr .= "Cc: <{$cc}>\r\n";
        if(!empty($bcc))
            $rawMsgStr .= "Bcc: <{$bcc}>\r\n";
        $rawMsgStr .= "MIME-Version: 1.0\r\n";
        $rawMsgStr .= "Content-Type: text/html; charset=utf-8\r\n";
        $rawMsgStr .= 'Content-Transfer-Encoding: quoted-printable' . "\r\n\r\n";
        $rawMsgStr .= "{$messageText}\r\n";

        // The message needs to be encoded in Base64URL
        $mime = rtrim(strtr(base64_encode($rawMsgStr), '+/', '-_'), '=');
        $msg = new Google_Service_Gmail_Message();

        $msg->setRaw($mime);

        return $msg;
    }
}


?>
