<?php
require_once 'vendor/autoload.php';
$params = require_once('config/params.php');

session_start();

$secretKey = ($params['environment'] == 'live' ? $params['stripeLiveSecretKey'] : $params['stripeTestSecretKey']);
//$stripe = new \Stripe\StripeClient([
//    // This is your test secret API key.
//    "api_key" => 'sk_test_51OYivmDZ8rkGkZqkH2X0SNDw6ReiGjlunBjfLb3SHtMlpMGcZ4sNTokCoWxbZ1ioeSUvpqJi61jDb2W27zemJMDT00tPNCfHI6',
//]);

//echo $secretKey;


$stripe = new \Stripe\StripeClient($secretKey);

try {

    $account_session = $stripe->accountSessions->create([
        'account' => 'acct_1Q4GEEDHW9ikKLuZ',
      'components' => [
        'payments' => [
            'enabled' => true,
            'features' => [
                'refund_management' => true,
                'dispute_management' => true,
                'capture_payments' => true,
            ],
        ],
          'balances' => [
              'enabled' => true,
              'features' => [
                  'instant_payouts' => true,
                  'standard_payouts' => true,
                  'edit_payout_schedule' => true,
              ],
          ],
          'account_onboarding' => [
              'enabled' => true,
              'features' => ['external_account_collection' => true],
          ],
          'account_management' => [
              'enabled' => true,
              'features' => ['external_account_collection' => true],
          ],
          'notification_banner' => [
              'enabled' => true,
              'features' => ['external_account_collection' => true],
          ],
          'documents' => ['enabled' => true],
          'payouts' => [
              'enabled' => true,
              'features' => [
                  'instant_payouts' => true,
                  'standard_payouts' => true,
                  'edit_payout_schedule' => true,
                  'external_account_collection' => true,
              ],
          ],
          'payouts_list' => ['enabled' => true],
      ],
    ]);

    echo json_encode(array(
        'client_secret' => $account_session->client_secret
    ));
  } catch (Exception $e) {
    error_log("An error occurred when calling the Stripe API to create an account session: {$e->getMessage()}");
//    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}

?>